# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import FormIntroduction
    from . import FormMessage
    from . import FormPage

class Form(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Form - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'form_description': 'str',
            'received_message': 'FormMessage',
            'reply_message': 'FormMessage',
            'introduction': 'FormIntroduction',
            'form_pages': 'list[FormPage]',
            'show_summary': 'bool'
        }

        self.attribute_map = {
            'form_description': 'formDescription',
            'received_message': 'receivedMessage',
            'reply_message': 'replyMessage',
            'introduction': 'introduction',
            'form_pages': 'formPages',
            'show_summary': 'showSummary'
        }

        self._form_description = None
        self._received_message = None
        self._reply_message = None
        self._introduction = None
        self._form_pages = None
        self._show_summary = None

    @property
    def form_description(self) -> str:
        """
        Gets the form_description of this Form.
        Description of the form

        :return: The form_description of this Form.
        :rtype: str
        """
        return self._form_description

    @form_description.setter
    def form_description(self, form_description: str) -> None:
        """
        Sets the form_description of this Form.
        Description of the form

        :param form_description: The form_description of this Form.
        :type: str
        """
        

        self._form_description = form_description

    @property
    def received_message(self) -> 'FormMessage':
        """
        Gets the received_message of this Form.
        Message displayed when response is received

        :return: The received_message of this Form.
        :rtype: FormMessage
        """
        return self._received_message

    @received_message.setter
    def received_message(self, received_message: 'FormMessage') -> None:
        """
        Sets the received_message of this Form.
        Message displayed when response is received

        :param received_message: The received_message of this Form.
        :type: FormMessage
        """
        

        self._received_message = received_message

    @property
    def reply_message(self) -> 'FormMessage':
        """
        Gets the reply_message of this Form.
        Message displayed as reply

        :return: The reply_message of this Form.
        :rtype: FormMessage
        """
        return self._reply_message

    @reply_message.setter
    def reply_message(self, reply_message: 'FormMessage') -> None:
        """
        Sets the reply_message of this Form.
        Message displayed as reply

        :param reply_message: The reply_message of this Form.
        :type: FormMessage
        """
        

        self._reply_message = reply_message

    @property
    def introduction(self) -> 'FormIntroduction':
        """
        Gets the introduction of this Form.
        Introduction section of the form

        :return: The introduction of this Form.
        :rtype: FormIntroduction
        """
        return self._introduction

    @introduction.setter
    def introduction(self, introduction: 'FormIntroduction') -> None:
        """
        Sets the introduction of this Form.
        Introduction section of the form

        :param introduction: The introduction of this Form.
        :type: FormIntroduction
        """
        

        self._introduction = introduction

    @property
    def form_pages(self) -> List['FormPage']:
        """
        Gets the form_pages of this Form.
        Pages of the form

        :return: The form_pages of this Form.
        :rtype: list[FormPage]
        """
        return self._form_pages

    @form_pages.setter
    def form_pages(self, form_pages: List['FormPage']) -> None:
        """
        Sets the form_pages of this Form.
        Pages of the form

        :param form_pages: The form_pages of this Form.
        :type: list[FormPage]
        """
        

        self._form_pages = form_pages

    @property
    def show_summary(self) -> bool:
        """
        Gets the show_summary of this Form.
        Whether to show a summary after form completion

        :return: The show_summary of this Form.
        :rtype: bool
        """
        return self._show_summary

    @show_summary.setter
    def show_summary(self, show_summary: bool) -> None:
        """
        Sets the show_summary of this Form.
        Whether to show a summary after form completion

        :param show_summary: The show_summary of this Form.
        :type: bool
        """
        

        self._show_summary = show_summary

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

