# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class FormIntroduction(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        FormIntroduction - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'title': 'str',
            'image_url': 'str',
            'subtitle': 'str',
            'button_text': 'str'
        }

        self.attribute_map = {
            'title': 'title',
            'image_url': 'imageUrl',
            'subtitle': 'subtitle',
            'button_text': 'buttonText'
        }

        self._title = None
        self._image_url = None
        self._subtitle = None
        self._button_text = None

    @property
    def title(self) -> str:
        """
        Gets the title of this FormIntroduction.
        Title of the introduction

        :return: The title of this FormIntroduction.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this FormIntroduction.
        Title of the introduction

        :param title: The title of this FormIntroduction.
        :type: str
        """
        

        self._title = title

    @property
    def image_url(self) -> str:
        """
        Gets the image_url of this FormIntroduction.
        URL of the image to display

        :return: The image_url of this FormIntroduction.
        :rtype: str
        """
        return self._image_url

    @image_url.setter
    def image_url(self, image_url: str) -> None:
        """
        Sets the image_url of this FormIntroduction.
        URL of the image to display

        :param image_url: The image_url of this FormIntroduction.
        :type: str
        """
        

        self._image_url = image_url

    @property
    def subtitle(self) -> str:
        """
        Gets the subtitle of this FormIntroduction.
        Subtitle of the introduction

        :return: The subtitle of this FormIntroduction.
        :rtype: str
        """
        return self._subtitle

    @subtitle.setter
    def subtitle(self, subtitle: str) -> None:
        """
        Sets the subtitle of this FormIntroduction.
        Subtitle of the introduction

        :param subtitle: The subtitle of this FormIntroduction.
        :type: str
        """
        

        self._subtitle = subtitle

    @property
    def button_text(self) -> str:
        """
        Gets the button_text of this FormIntroduction.
        Text for the start button

        :return: The button_text of this FormIntroduction.
        :rtype: str
        """
        return self._button_text

    @button_text.setter
    def button_text(self, button_text: str) -> None:
        """
        Sets the button_text of this FormIntroduction.
        Text for the start button

        :param button_text: The button_text of this FormIntroduction.
        :type: str
        """
        

        self._button_text = button_text

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

