# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import FormDatePicker
    from . import FormListPicker
    from . import Input
    from . import WheelPicker

class FormPageComponent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        FormPageComponent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'form_component_type': 'str',
            'list_picker': 'FormListPicker',
            'date_picker': 'FormDatePicker',
            'input': 'Input',
            'wheel_picker': 'WheelPicker'
        }

        self.attribute_map = {
            'form_component_type': 'formComponentType',
            'list_picker': 'listPicker',
            'date_picker': 'datePicker',
            'input': 'input',
            'wheel_picker': 'wheelPicker'
        }

        self._form_component_type = None
        self._list_picker = None
        self._date_picker = None
        self._input = None
        self._wheel_picker = None

    @property
    def form_component_type(self) -> str:
        """
        Gets the form_component_type of this FormPageComponent.
        Type of the component

        :return: The form_component_type of this FormPageComponent.
        :rtype: str
        """
        return self._form_component_type

    @form_component_type.setter
    def form_component_type(self, form_component_type: str) -> None:
        """
        Sets the form_component_type of this FormPageComponent.
        Type of the component

        :param form_component_type: The form_component_type of this FormPageComponent.
        :type: str
        """
        if isinstance(form_component_type, int):
            form_component_type = str(form_component_type)
        allowed_values = ["ListPicker", "DatePicker", "Input", "WheelPicker"]
        if form_component_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for form_component_type -> " + form_component_type)
            self._form_component_type = "outdated_sdk_version"
        else:
            self._form_component_type = form_component_type

    @property
    def list_picker(self) -> 'FormListPicker':
        """
        Gets the list_picker of this FormPageComponent.
        List picker configuration

        :return: The list_picker of this FormPageComponent.
        :rtype: FormListPicker
        """
        return self._list_picker

    @list_picker.setter
    def list_picker(self, list_picker: 'FormListPicker') -> None:
        """
        Sets the list_picker of this FormPageComponent.
        List picker configuration

        :param list_picker: The list_picker of this FormPageComponent.
        :type: FormListPicker
        """
        

        self._list_picker = list_picker

    @property
    def date_picker(self) -> 'FormDatePicker':
        """
        Gets the date_picker of this FormPageComponent.
        Date picker configuration

        :return: The date_picker of this FormPageComponent.
        :rtype: FormDatePicker
        """
        return self._date_picker

    @date_picker.setter
    def date_picker(self, date_picker: 'FormDatePicker') -> None:
        """
        Sets the date_picker of this FormPageComponent.
        Date picker configuration

        :param date_picker: The date_picker of this FormPageComponent.
        :type: FormDatePicker
        """
        

        self._date_picker = date_picker

    @property
    def input(self) -> 'Input':
        """
        Gets the input of this FormPageComponent.
        Input field configuration

        :return: The input of this FormPageComponent.
        :rtype: Input
        """
        return self._input

    @input.setter
    def input(self, input: 'Input') -> None:
        """
        Sets the input of this FormPageComponent.
        Input field configuration

        :param input: The input of this FormPageComponent.
        :type: Input
        """
        

        self._input = input

    @property
    def wheel_picker(self) -> 'WheelPicker':
        """
        Gets the wheel_picker of this FormPageComponent.
        Wheel picker configuration

        :return: The wheel_picker of this FormPageComponent.
        :rtype: WheelPicker
        """
        return self._wheel_picker

    @wheel_picker.setter
    def wheel_picker(self, wheel_picker: 'WheelPicker') -> None:
        """
        Sets the wheel_picker of this FormPageComponent.
        Wheel picker configuration

        :param wheel_picker: The wheel_picker of this FormPageComponent.
        :type: WheelPicker
        """
        

        self._wheel_picker = wheel_picker

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

