# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class FunctionUploadRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        FunctionUploadRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'file_name': 'str',
            'signed_url_timeout_seconds': 'int'
        }

        self.attribute_map = {
            'file_name': 'fileName',
            'signed_url_timeout_seconds': 'signedUrlTimeoutSeconds'
        }

        self._file_name = None
        self._signed_url_timeout_seconds = None

    @property
    def file_name(self) -> str:
        """
        Gets the file_name of this FunctionUploadRequest.
        Name of the file to upload.File name can only contain letters, numbers, and the following special characters: + - _ . ' ( )

        :return: The file_name of this FunctionUploadRequest.
        :rtype: str
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name: str) -> None:
        """
        Sets the file_name of this FunctionUploadRequest.
        Name of the file to upload.File name can only contain letters, numbers, and the following special characters: + - _ . ' ( )

        :param file_name: The file_name of this FunctionUploadRequest.
        :type: str
        """
        
        if not re.search('^[a-zA-Z0-9\.\+\-\_\(\)\s]+$', file_name):
            raise ValueError("Invalid value for `file_name`, must be a follow pattern or equal to `/^[a-zA-Z0-9\.\+\-\_\(\)\s]+$/`")


        self._file_name = file_name

    @property
    def signed_url_timeout_seconds(self) -> int:
        """
        Gets the signed_url_timeout_seconds of this FunctionUploadRequest.
        The number of seconds the presigned URL is valid for (from 1 to 604800 seconds). If none provided, defaults to 900 seconds

        :return: The signed_url_timeout_seconds of this FunctionUploadRequest.
        :rtype: int
        """
        return self._signed_url_timeout_seconds

    @signed_url_timeout_seconds.setter
    def signed_url_timeout_seconds(self, signed_url_timeout_seconds: int) -> None:
        """
        Sets the signed_url_timeout_seconds of this FunctionUploadRequest.
        The number of seconds the presigned URL is valid for (from 1 to 604800 seconds). If none provided, defaults to 900 seconds

        :param signed_url_timeout_seconds: The signed_url_timeout_seconds of this FunctionUploadRequest.
        :type: int
        """
        
        if signed_url_timeout_seconds > 604800:
            raise ValueError("Invalid value for `signed_url_timeout_seconds`, must be a value less than or equal to `604800`")

        if signed_url_timeout_seconds < 1:
            raise ValueError("Invalid value for `signed_url_timeout_seconds`, must be a value greater than or equal to `1`")


        self._signed_url_timeout_seconds = signed_url_timeout_seconds

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

