# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class FunctionZipConfig(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        FunctionZipConfig - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'status': 'str',
            'id': 'str',
            'name': 'str',
            'date_created': 'datetime',
            'error_message': 'str',
            'request_id': 'str'
        }

        self.attribute_map = {
            'status': 'status',
            'id': 'id',
            'name': 'name',
            'date_created': 'dateCreated',
            'error_message': 'errorMessage',
            'request_id': 'requestId'
        }

        self._status = None
        self._id = None
        self._name = None
        self._date_created = None
        self._error_message = None
        self._request_id = None

    @property
    def status(self) -> str:
        """
        Gets the status of this FunctionZipConfig.
        Status of zip upload.

        :return: The status of this FunctionZipConfig.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this FunctionZipConfig.
        Status of zip upload.

        :param status: The status of this FunctionZipConfig.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Pending", "Transferring", "Available", "Unknown", "Invalid", "InvalidFormat", "InvalidFile"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def id(self) -> str:
        """
        Gets the id of this FunctionZipConfig.
        Zip file Identifier

        :return: The id of this FunctionZipConfig.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this FunctionZipConfig.
        Zip file Identifier

        :param id: The id of this FunctionZipConfig.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this FunctionZipConfig.
        Zip file name

        :return: The name of this FunctionZipConfig.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this FunctionZipConfig.
        Zip file name

        :param name: The name of this FunctionZipConfig.
        :type: str
        """
        

        self._name = name

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this FunctionZipConfig.
        Date and time zip record was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this FunctionZipConfig.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this FunctionZipConfig.
        Date and time zip record was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this FunctionZipConfig.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def error_message(self) -> str:
        """
        Gets the error_message of this FunctionZipConfig.
        Error message if upload failed.

        :return: The error_message of this FunctionZipConfig.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message: str) -> None:
        """
        Sets the error_message of this FunctionZipConfig.
        Error message if upload failed.

        :param error_message: The error_message of this FunctionZipConfig.
        :type: str
        """
        

        self._error_message = error_message

    @property
    def request_id(self) -> str:
        """
        Gets the request_id of this FunctionZipConfig.
        Upload request id used for zip upload

        :return: The request_id of this FunctionZipConfig.
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id: str) -> None:
        """
        Sets the request_id of this FunctionZipConfig.
        Upload request id used for zip upload

        :param request_id: The request_id of this FunctionZipConfig.
        :type: str
        """
        

        self._request_id = request_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

