# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DomainEntityRef
    from . import GDPRSubject
    from . import ReplacementTerm

class GDPRRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        GDPRRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'created_by': 'DomainEntityRef',
            'replacement_terms': 'list[ReplacementTerm]',
            'request_type': 'str',
            'created_date': 'datetime',
            'status': 'str',
            'subject': 'GDPRSubject',
            'results_url': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'created_by': 'createdBy',
            'replacement_terms': 'replacementTerms',
            'request_type': 'requestType',
            'created_date': 'createdDate',
            'status': 'status',
            'subject': 'subject',
            'results_url': 'resultsUrl',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._created_by = None
        self._replacement_terms = None
        self._request_type = None
        self._created_date = None
        self._status = None
        self._subject = None
        self._results_url = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this GDPRRequest.
        The globally unique identifier for the object.

        :return: The id of this GDPRRequest.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this GDPRRequest.
        The globally unique identifier for the object.

        :param id: The id of this GDPRRequest.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this GDPRRequest.


        :return: The name of this GDPRRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this GDPRRequest.


        :param name: The name of this GDPRRequest.
        :type: str
        """
        

        self._name = name

    @property
    def created_by(self) -> 'DomainEntityRef':
        """
        Gets the created_by of this GDPRRequest.
        The user that created this request

        :return: The created_by of this GDPRRequest.
        :rtype: DomainEntityRef
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'DomainEntityRef') -> None:
        """
        Sets the created_by of this GDPRRequest.
        The user that created this request

        :param created_by: The created_by of this GDPRRequest.
        :type: DomainEntityRef
        """
        

        self._created_by = created_by

    @property
    def replacement_terms(self) -> List['ReplacementTerm']:
        """
        Gets the replacement_terms of this GDPRRequest.
        The replacement terms for the provided search terms, in the case of a GDPR_UPDATE request

        :return: The replacement_terms of this GDPRRequest.
        :rtype: list[ReplacementTerm]
        """
        return self._replacement_terms

    @replacement_terms.setter
    def replacement_terms(self, replacement_terms: List['ReplacementTerm']) -> None:
        """
        Sets the replacement_terms of this GDPRRequest.
        The replacement terms for the provided search terms, in the case of a GDPR_UPDATE request

        :param replacement_terms: The replacement_terms of this GDPRRequest.
        :type: list[ReplacementTerm]
        """
        

        self._replacement_terms = replacement_terms

    @property
    def request_type(self) -> str:
        """
        Gets the request_type of this GDPRRequest.
        The type of GDPR request

        :return: The request_type of this GDPRRequest.
        :rtype: str
        """
        return self._request_type

    @request_type.setter
    def request_type(self, request_type: str) -> None:
        """
        Sets the request_type of this GDPRRequest.
        The type of GDPR request

        :param request_type: The request_type of this GDPRRequest.
        :type: str
        """
        if isinstance(request_type, int):
            request_type = str(request_type)
        allowed_values = ["GDPR_EXPORT", "GDPR_UPDATE", "GDPR_DELETE"]
        if request_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for request_type -> " + request_type)
            self._request_type = "outdated_sdk_version"
        else:
            self._request_type = request_type

    @property
    def created_date(self) -> datetime:
        """
        Gets the created_date of this GDPRRequest.
        When the request was submitted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The created_date of this GDPRRequest.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date: datetime) -> None:
        """
        Sets the created_date of this GDPRRequest.
        When the request was submitted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param created_date: The created_date of this GDPRRequest.
        :type: datetime
        """
        

        self._created_date = created_date

    @property
    def status(self) -> str:
        """
        Gets the status of this GDPRRequest.
        The status of the request

        :return: The status of this GDPRRequest.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this GDPRRequest.
        The status of the request

        :param status: The status of this GDPRRequest.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["INITIATED", "SEARCHING", "UPDATING", "DELETING", "COMPLETED", "ERROR", "FINALIZING"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def subject(self) -> 'GDPRSubject':
        """
        Gets the subject of this GDPRRequest.
        The subject of the GDPR request

        :return: The subject of this GDPRRequest.
        :rtype: GDPRSubject
        """
        return self._subject

    @subject.setter
    def subject(self, subject: 'GDPRSubject') -> None:
        """
        Sets the subject of this GDPRRequest.
        The subject of the GDPR request

        :param subject: The subject of this GDPRRequest.
        :type: GDPRSubject
        """
        

        self._subject = subject

    @property
    def results_url(self) -> str:
        """
        Gets the results_url of this GDPRRequest.
        The location where the results of the request can be retrieved

        :return: The results_url of this GDPRRequest.
        :rtype: str
        """
        return self._results_url

    @results_url.setter
    def results_url(self, results_url: str) -> None:
        """
        Sets the results_url of this GDPRRequest.
        The location where the results of the request can be retrieved

        :param results_url: The results_url of this GDPRRequest.
        :type: str
        """
        

        self._results_url = results_url

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this GDPRRequest.
        The URI for this object

        :return: The self_uri of this GDPRRequest.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this GDPRRequest.
        The URI for this object

        :param self_uri: The self_uri of this GDPRRequest.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

