# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class GuestMemberInfo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        GuestMemberInfo - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'display_name': 'str',
            'first_name': 'str',
            'last_name': 'str',
            'email': 'str',
            'phone_number': 'str',
            'avatar_image_url': 'str',
            'custom_fields': 'dict(str, str)'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'first_name': 'firstName',
            'last_name': 'lastName',
            'email': 'email',
            'phone_number': 'phoneNumber',
            'avatar_image_url': 'avatarImageUrl',
            'custom_fields': 'customFields'
        }

        self._display_name = None
        self._first_name = None
        self._last_name = None
        self._email = None
        self._phone_number = None
        self._avatar_image_url = None
        self._custom_fields = None

    @property
    def display_name(self) -> str:
        """
        Gets the display_name of this GuestMemberInfo.
        The display name to use for the guest member in the conversation.

        :return: The display_name of this GuestMemberInfo.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name: str) -> None:
        """
        Sets the display_name of this GuestMemberInfo.
        The display name to use for the guest member in the conversation.

        :param display_name: The display_name of this GuestMemberInfo.
        :type: str
        """
        

        self._display_name = display_name

    @property
    def first_name(self) -> str:
        """
        Gets the first_name of this GuestMemberInfo.
        The first name to use for the guest member in the conversation.

        :return: The first_name of this GuestMemberInfo.
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name: str) -> None:
        """
        Sets the first_name of this GuestMemberInfo.
        The first name to use for the guest member in the conversation.

        :param first_name: The first_name of this GuestMemberInfo.
        :type: str
        """
        

        self._first_name = first_name

    @property
    def last_name(self) -> str:
        """
        Gets the last_name of this GuestMemberInfo.
        The last name to use for the guest member in the conversation.

        :return: The last_name of this GuestMemberInfo.
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name: str) -> None:
        """
        Sets the last_name of this GuestMemberInfo.
        The last name to use for the guest member in the conversation.

        :param last_name: The last_name of this GuestMemberInfo.
        :type: str
        """
        

        self._last_name = last_name

    @property
    def email(self) -> str:
        """
        Gets the email of this GuestMemberInfo.
        The email address to use for the guest member in the conversation.

        :return: The email of this GuestMemberInfo.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email: str) -> None:
        """
        Sets the email of this GuestMemberInfo.
        The email address to use for the guest member in the conversation.

        :param email: The email of this GuestMemberInfo.
        :type: str
        """
        

        self._email = email

    @property
    def phone_number(self) -> str:
        """
        Gets the phone_number of this GuestMemberInfo.
        The phone number to use for the guest member in the conversation.

        :return: The phone_number of this GuestMemberInfo.
        :rtype: str
        """
        return self._phone_number

    @phone_number.setter
    def phone_number(self, phone_number: str) -> None:
        """
        Sets the phone_number of this GuestMemberInfo.
        The phone number to use for the guest member in the conversation.

        :param phone_number: The phone_number of this GuestMemberInfo.
        :type: str
        """
        

        self._phone_number = phone_number

    @property
    def avatar_image_url(self) -> str:
        """
        Gets the avatar_image_url of this GuestMemberInfo.
        The URL to the avatar image to use for the guest member in the conversation, if any.

        :return: The avatar_image_url of this GuestMemberInfo.
        :rtype: str
        """
        return self._avatar_image_url

    @avatar_image_url.setter
    def avatar_image_url(self, avatar_image_url: str) -> None:
        """
        Sets the avatar_image_url of this GuestMemberInfo.
        The URL to the avatar image to use for the guest member in the conversation, if any.

        :param avatar_image_url: The avatar_image_url of this GuestMemberInfo.
        :type: str
        """
        

        self._avatar_image_url = avatar_image_url

    @property
    def custom_fields(self) -> Dict[str, str]:
        """
        Gets the custom_fields of this GuestMemberInfo.
        Any custom fields of information, in key-value format, to attach to the guest member in the conversation.

        :return: The custom_fields of this GuestMemberInfo.
        :rtype: dict(str, str)
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields: Dict[str, str]) -> None:
        """
        Sets the custom_fields of this GuestMemberInfo.
        Any custom fields of information, in key-value format, to attach to the guest member in the conversation.

        :param custom_fields: The custom_fields of this GuestMemberInfo.
        :type: dict(str, str)
        """
        

        self._custom_fields = custom_fields

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

