# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import GuideVersionRef

class Guide(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Guide - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'status': 'str',
            'source': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'self_uri': 'str',
            'latest_saved_version': 'GuideVersionRef',
            'latest_production_ready_version': 'GuideVersionRef'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'status': 'status',
            'source': 'source',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'self_uri': 'selfUri',
            'latest_saved_version': 'latestSavedVersion',
            'latest_production_ready_version': 'latestProductionReadyVersion'
        }

        self._id = None
        self._name = None
        self._status = None
        self._source = None
        self._date_created = None
        self._date_modified = None
        self._self_uri = None
        self._latest_saved_version = None
        self._latest_production_ready_version = None

    @property
    def id(self) -> str:
        """
        Gets the id of this Guide.
        The globally unique identifier for the object.

        :return: The id of this Guide.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this Guide.
        The globally unique identifier for the object.

        :param id: The id of this Guide.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this Guide.
        The name of the guide.

        :return: The name of this Guide.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this Guide.
        The name of the guide.

        :param name: The name of this Guide.
        :type: str
        """
        

        self._name = name

    @property
    def status(self) -> str:
        """
        Gets the status of this Guide.
        The status of the guide.

        :return: The status of this Guide.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this Guide.
        The status of the guide.

        :param status: The status of this Guide.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Published", "Draft"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def source(self) -> str:
        """
        Gets the source of this Guide.
        Indicates how the guide content was generated.

        :return: The source of this Guide.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source: str) -> None:
        """
        Sets the source of this Guide.
        Indicates how the guide content was generated.

        :param source: The source of this Guide.
        :type: str
        """
        if isinstance(source, int):
            source = str(source)
        allowed_values = ["Manual", "Prompt", "Document"]
        if source.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for source -> " + source)
            self._source = "outdated_sdk_version"
        else:
            self._source = source

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this Guide.
        The date and time the guide was created.. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this Guide.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this Guide.
        The date and time the guide was created.. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this Guide.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this Guide.
        The date and time the guide was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this Guide.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this Guide.
        The date and time the guide was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this Guide.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this Guide.
        The URI for this object

        :return: The self_uri of this Guide.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this Guide.
        The URI for this object

        :param self_uri: The self_uri of this Guide.
        :type: str
        """
        

        self._self_uri = self_uri

    @property
    def latest_saved_version(self) -> 'GuideVersionRef':
        """
        Gets the latest_saved_version of this Guide.
        The latest saved version of the guide.

        :return: The latest_saved_version of this Guide.
        :rtype: GuideVersionRef
        """
        return self._latest_saved_version

    @latest_saved_version.setter
    def latest_saved_version(self, latest_saved_version: 'GuideVersionRef') -> None:
        """
        Sets the latest_saved_version of this Guide.
        The latest saved version of the guide.

        :param latest_saved_version: The latest_saved_version of this Guide.
        :type: GuideVersionRef
        """
        

        self._latest_saved_version = latest_saved_version

    @property
    def latest_production_ready_version(self) -> 'GuideVersionRef':
        """
        Gets the latest_production_ready_version of this Guide.
        The latest production ready version of the guide.

        :return: The latest_production_ready_version of this Guide.
        :rtype: GuideVersionRef
        """
        return self._latest_production_ready_version

    @latest_production_ready_version.setter
    def latest_production_ready_version(self, latest_production_ready_version: 'GuideVersionRef') -> None:
        """
        Sets the latest_production_ready_version of this Guide.
        The latest production ready version of the guide.

        :param latest_production_ready_version: The latest_production_ready_version of this Guide.
        :type: GuideVersionRef
        """
        

        self._latest_production_ready_version = latest_production_ready_version

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

