# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import GuideVersionResources
    from . import Variable

class GuideVersion(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        GuideVersion - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'self_uri': 'str',
            'guide': 'AddressableEntityRef',
            'version': 'str',
            'instruction': 'str',
            'state': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'variables': 'list[Variable]',
            'resources': 'GuideVersionResources'
        }

        self.attribute_map = {
            'self_uri': 'selfUri',
            'guide': 'guide',
            'version': 'version',
            'instruction': 'instruction',
            'state': 'state',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'variables': 'variables',
            'resources': 'resources'
        }

        self._self_uri = None
        self._guide = None
        self._version = None
        self._instruction = None
        self._state = None
        self._date_created = None
        self._date_modified = None
        self._variables = None
        self._resources = None

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this GuideVersion.


        :return: The self_uri of this GuideVersion.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this GuideVersion.


        :param self_uri: The self_uri of this GuideVersion.
        :type: str
        """
        

        self._self_uri = self_uri

    @property
    def guide(self) -> 'AddressableEntityRef':
        """
        Gets the guide of this GuideVersion.
        The guide this version belongs to.

        :return: The guide of this GuideVersion.
        :rtype: AddressableEntityRef
        """
        return self._guide

    @guide.setter
    def guide(self, guide: 'AddressableEntityRef') -> None:
        """
        Sets the guide of this GuideVersion.
        The guide this version belongs to.

        :param guide: The guide of this GuideVersion.
        :type: AddressableEntityRef
        """
        

        self._guide = guide

    @property
    def version(self) -> str:
        """
        Gets the version of this GuideVersion.
        Guide version.

        :return: The version of this GuideVersion.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version: str) -> None:
        """
        Sets the version of this GuideVersion.
        Guide version.

        :param version: The version of this GuideVersion.
        :type: str
        """
        

        self._version = version

    @property
    def instruction(self) -> str:
        """
        Gets the instruction of this GuideVersion.
        The instruction given to this version of the guide, for how it should behave when interacting with a User.

        :return: The instruction of this GuideVersion.
        :rtype: str
        """
        return self._instruction

    @instruction.setter
    def instruction(self, instruction: str) -> None:
        """
        Sets the instruction of this GuideVersion.
        The instruction given to this version of the guide, for how it should behave when interacting with a User.

        :param instruction: The instruction of this GuideVersion.
        :type: str
        """
        

        self._instruction = instruction

    @property
    def state(self) -> str:
        """
        Gets the state of this GuideVersion.
        The current state of the guide version.

        :return: The state of this GuideVersion.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this GuideVersion.
        The current state of the guide version.

        :param state: The state of this GuideVersion.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Draft", "TestReady", "ProductionReady"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this GuideVersion.
        The date and time the guide version was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this GuideVersion.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this GuideVersion.
        The date and time the guide version was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this GuideVersion.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this GuideVersion.
        The date and time the guide version was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this GuideVersion.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this GuideVersion.
        The date and time the guide version was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this GuideVersion.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def variables(self) -> List['Variable']:
        """
        Gets the variables of this GuideVersion.
        The variables associated with this version of the guide. Includes input variables (provided) and output variables (captured during execution).

        :return: The variables of this GuideVersion.
        :rtype: list[Variable]
        """
        return self._variables

    @variables.setter
    def variables(self, variables: List['Variable']) -> None:
        """
        Sets the variables of this GuideVersion.
        The variables associated with this version of the guide. Includes input variables (provided) and output variables (captured during execution).

        :param variables: The variables of this GuideVersion.
        :type: list[Variable]
        """
        

        self._variables = variables

    @property
    def resources(self) -> 'GuideVersionResources':
        """
        Gets the resources of this GuideVersion.
        The resources associated with this version of the guide.

        :return: The resources of this GuideVersion.
        :rtype: GuideVersionResources
        """
        return self._resources

    @resources.setter
    def resources(self, resources: 'GuideVersionResources') -> None:
        """
        Sets the resources of this GuideVersion.
        The resources associated with this version of the guide.

        :param resources: The resources of this GuideVersion.
        :type: GuideVersionResources
        """
        

        self._resources = resources

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

