# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class HistoricalAdherenceDayMetrics(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        HistoricalAdherenceDayMetrics - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'day_start_offset_secs': 'int',
            'adherence_schedule_secs': 'int',
            'conformance_schedule_secs': 'int',
            'conformance_actual_secs': 'int',
            'exception_count': 'int',
            'exception_duration_secs': 'int',
            'impact_seconds': 'int',
            'schedule_length_secs': 'int',
            'actual_length_secs': 'int',
            'adherence_percentage': 'float',
            'conformance_percentage': 'float'
        }

        self.attribute_map = {
            'day_start_offset_secs': 'dayStartOffsetSecs',
            'adherence_schedule_secs': 'adherenceScheduleSecs',
            'conformance_schedule_secs': 'conformanceScheduleSecs',
            'conformance_actual_secs': 'conformanceActualSecs',
            'exception_count': 'exceptionCount',
            'exception_duration_secs': 'exceptionDurationSecs',
            'impact_seconds': 'impactSeconds',
            'schedule_length_secs': 'scheduleLengthSecs',
            'actual_length_secs': 'actualLengthSecs',
            'adherence_percentage': 'adherencePercentage',
            'conformance_percentage': 'conformancePercentage'
        }

        self._day_start_offset_secs = None
        self._adherence_schedule_secs = None
        self._conformance_schedule_secs = None
        self._conformance_actual_secs = None
        self._exception_count = None
        self._exception_duration_secs = None
        self._impact_seconds = None
        self._schedule_length_secs = None
        self._actual_length_secs = None
        self._adherence_percentage = None
        self._conformance_percentage = None

    @property
    def day_start_offset_secs(self) -> int:
        """
        Gets the day_start_offset_secs of this HistoricalAdherenceDayMetrics.
        Start of day offset in seconds relative to query start time

        :return: The day_start_offset_secs of this HistoricalAdherenceDayMetrics.
        :rtype: int
        """
        return self._day_start_offset_secs

    @day_start_offset_secs.setter
    def day_start_offset_secs(self, day_start_offset_secs: int) -> None:
        """
        Sets the day_start_offset_secs of this HistoricalAdherenceDayMetrics.
        Start of day offset in seconds relative to query start time

        :param day_start_offset_secs: The day_start_offset_secs of this HistoricalAdherenceDayMetrics.
        :type: int
        """
        

        self._day_start_offset_secs = day_start_offset_secs

    @property
    def adherence_schedule_secs(self) -> int:
        """
        Gets the adherence_schedule_secs of this HistoricalAdherenceDayMetrics.
        Duration of schedule in seconds included for adherence percentage calculation

        :return: The adherence_schedule_secs of this HistoricalAdherenceDayMetrics.
        :rtype: int
        """
        return self._adherence_schedule_secs

    @adherence_schedule_secs.setter
    def adherence_schedule_secs(self, adherence_schedule_secs: int) -> None:
        """
        Sets the adherence_schedule_secs of this HistoricalAdherenceDayMetrics.
        Duration of schedule in seconds included for adherence percentage calculation

        :param adherence_schedule_secs: The adherence_schedule_secs of this HistoricalAdherenceDayMetrics.
        :type: int
        """
        

        self._adherence_schedule_secs = adherence_schedule_secs

    @property
    def conformance_schedule_secs(self) -> int:
        """
        Gets the conformance_schedule_secs of this HistoricalAdherenceDayMetrics.
        Total scheduled duration in seconds for OnQueue activities

        :return: The conformance_schedule_secs of this HistoricalAdherenceDayMetrics.
        :rtype: int
        """
        return self._conformance_schedule_secs

    @conformance_schedule_secs.setter
    def conformance_schedule_secs(self, conformance_schedule_secs: int) -> None:
        """
        Sets the conformance_schedule_secs of this HistoricalAdherenceDayMetrics.
        Total scheduled duration in seconds for OnQueue activities

        :param conformance_schedule_secs: The conformance_schedule_secs of this HistoricalAdherenceDayMetrics.
        :type: int
        """
        

        self._conformance_schedule_secs = conformance_schedule_secs

    @property
    def conformance_actual_secs(self) -> int:
        """
        Gets the conformance_actual_secs of this HistoricalAdherenceDayMetrics.
        Total actually worked duration in seconds for OnQueue activities

        :return: The conformance_actual_secs of this HistoricalAdherenceDayMetrics.
        :rtype: int
        """
        return self._conformance_actual_secs

    @conformance_actual_secs.setter
    def conformance_actual_secs(self, conformance_actual_secs: int) -> None:
        """
        Sets the conformance_actual_secs of this HistoricalAdherenceDayMetrics.
        Total actually worked duration in seconds for OnQueue activities

        :param conformance_actual_secs: The conformance_actual_secs of this HistoricalAdherenceDayMetrics.
        :type: int
        """
        

        self._conformance_actual_secs = conformance_actual_secs

    @property
    def exception_count(self) -> int:
        """
        Gets the exception_count of this HistoricalAdherenceDayMetrics.
        Total number of adherence exceptions for this user

        :return: The exception_count of this HistoricalAdherenceDayMetrics.
        :rtype: int
        """
        return self._exception_count

    @exception_count.setter
    def exception_count(self, exception_count: int) -> None:
        """
        Sets the exception_count of this HistoricalAdherenceDayMetrics.
        Total number of adherence exceptions for this user

        :param exception_count: The exception_count of this HistoricalAdherenceDayMetrics.
        :type: int
        """
        

        self._exception_count = exception_count

    @property
    def exception_duration_secs(self) -> int:
        """
        Gets the exception_duration_secs of this HistoricalAdherenceDayMetrics.
        Total duration in seconds of adherence exceptions for this user

        :return: The exception_duration_secs of this HistoricalAdherenceDayMetrics.
        :rtype: int
        """
        return self._exception_duration_secs

    @exception_duration_secs.setter
    def exception_duration_secs(self, exception_duration_secs: int) -> None:
        """
        Sets the exception_duration_secs of this HistoricalAdherenceDayMetrics.
        Total duration in seconds of adherence exceptions for this user

        :param exception_duration_secs: The exception_duration_secs of this HistoricalAdherenceDayMetrics.
        :type: int
        """
        

        self._exception_duration_secs = exception_duration_secs

    @property
    def impact_seconds(self) -> int:
        """
        Gets the impact_seconds of this HistoricalAdherenceDayMetrics.
        The impact duration in seconds of current adherence state for this user

        :return: The impact_seconds of this HistoricalAdherenceDayMetrics.
        :rtype: int
        """
        return self._impact_seconds

    @impact_seconds.setter
    def impact_seconds(self, impact_seconds: int) -> None:
        """
        Sets the impact_seconds of this HistoricalAdherenceDayMetrics.
        The impact duration in seconds of current adherence state for this user

        :param impact_seconds: The impact_seconds of this HistoricalAdherenceDayMetrics.
        :type: int
        """
        

        self._impact_seconds = impact_seconds

    @property
    def schedule_length_secs(self) -> int:
        """
        Gets the schedule_length_secs of this HistoricalAdherenceDayMetrics.
        Total duration in seconds for all scheduled activities

        :return: The schedule_length_secs of this HistoricalAdherenceDayMetrics.
        :rtype: int
        """
        return self._schedule_length_secs

    @schedule_length_secs.setter
    def schedule_length_secs(self, schedule_length_secs: int) -> None:
        """
        Sets the schedule_length_secs of this HistoricalAdherenceDayMetrics.
        Total duration in seconds for all scheduled activities

        :param schedule_length_secs: The schedule_length_secs of this HistoricalAdherenceDayMetrics.
        :type: int
        """
        

        self._schedule_length_secs = schedule_length_secs

    @property
    def actual_length_secs(self) -> int:
        """
        Gets the actual_length_secs of this HistoricalAdherenceDayMetrics.
        Total duration in seconds for all actually worked activities

        :return: The actual_length_secs of this HistoricalAdherenceDayMetrics.
        :rtype: int
        """
        return self._actual_length_secs

    @actual_length_secs.setter
    def actual_length_secs(self, actual_length_secs: int) -> None:
        """
        Sets the actual_length_secs of this HistoricalAdherenceDayMetrics.
        Total duration in seconds for all actually worked activities

        :param actual_length_secs: The actual_length_secs of this HistoricalAdherenceDayMetrics.
        :type: int
        """
        

        self._actual_length_secs = actual_length_secs

    @property
    def adherence_percentage(self) -> float:
        """
        Gets the adherence_percentage of this HistoricalAdherenceDayMetrics.
        Total adherence percentage for this user, in the scale of 0 - 100

        :return: The adherence_percentage of this HistoricalAdherenceDayMetrics.
        :rtype: float
        """
        return self._adherence_percentage

    @adherence_percentage.setter
    def adherence_percentage(self, adherence_percentage: float) -> None:
        """
        Sets the adherence_percentage of this HistoricalAdherenceDayMetrics.
        Total adherence percentage for this user, in the scale of 0 - 100

        :param adherence_percentage: The adherence_percentage of this HistoricalAdherenceDayMetrics.
        :type: float
        """
        

        self._adherence_percentage = adherence_percentage

    @property
    def conformance_percentage(self) -> float:
        """
        Gets the conformance_percentage of this HistoricalAdherenceDayMetrics.
        Total conformance percentage for this user, in the scale of 0 - 100. Conformance percentage can be greater than 100 when the actual on-queue time is greater than the scheduled on-queue time for the same period.

        :return: The conformance_percentage of this HistoricalAdherenceDayMetrics.
        :rtype: float
        """
        return self._conformance_percentage

    @conformance_percentage.setter
    def conformance_percentage(self, conformance_percentage: float) -> None:
        """
        Sets the conformance_percentage of this HistoricalAdherenceDayMetrics.
        Total conformance percentage for this user, in the scale of 0 - 100. Conformance percentage can be greater than 100 when the actual on-queue time is greater than the scheduled on-queue time for the same period.

        :param conformance_percentage: The conformance_percentage of this HistoricalAdherenceDayMetrics.
        :type: float
        """
        

        self._conformance_percentage = conformance_percentage

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

