# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import HistoricalShrinkageActivityCodeResponse
    from . import HistoricalShrinkageAggregateResponse

class HistoricalShrinkageActivityCategoryResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        HistoricalShrinkageActivityCategoryResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'activity_category': 'str',
            'shrinkage_for_activity_category': 'HistoricalShrinkageAggregateResponse',
            'shrinkage_for_activity_codes': 'list[HistoricalShrinkageActivityCodeResponse]'
        }

        self.attribute_map = {
            'activity_category': 'activityCategory',
            'shrinkage_for_activity_category': 'shrinkageForActivityCategory',
            'shrinkage_for_activity_codes': 'shrinkageForActivityCodes'
        }

        self._activity_category = None
        self._shrinkage_for_activity_category = None
        self._shrinkage_for_activity_codes = None

    @property
    def activity_category(self) -> str:
        """
        Gets the activity_category of this HistoricalShrinkageActivityCategoryResponse.
        Activity category for which shrinkage data is provided

        :return: The activity_category of this HistoricalShrinkageActivityCategoryResponse.
        :rtype: str
        """
        return self._activity_category

    @activity_category.setter
    def activity_category(self, activity_category: str) -> None:
        """
        Sets the activity_category of this HistoricalShrinkageActivityCategoryResponse.
        Activity category for which shrinkage data is provided

        :param activity_category: The activity_category of this HistoricalShrinkageActivityCategoryResponse.
        :type: str
        """
        if isinstance(activity_category, int):
            activity_category = str(activity_category)
        allowed_values = ["OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "Unscheduled"]
        if activity_category.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for activity_category -> " + activity_category)
            self._activity_category = "outdated_sdk_version"
        else:
            self._activity_category = activity_category

    @property
    def shrinkage_for_activity_category(self) -> 'HistoricalShrinkageAggregateResponse':
        """
        Gets the shrinkage_for_activity_category of this HistoricalShrinkageActivityCategoryResponse.
        Aggregated shrinkage data for the activity category

        :return: The shrinkage_for_activity_category of this HistoricalShrinkageActivityCategoryResponse.
        :rtype: HistoricalShrinkageAggregateResponse
        """
        return self._shrinkage_for_activity_category

    @shrinkage_for_activity_category.setter
    def shrinkage_for_activity_category(self, shrinkage_for_activity_category: 'HistoricalShrinkageAggregateResponse') -> None:
        """
        Sets the shrinkage_for_activity_category of this HistoricalShrinkageActivityCategoryResponse.
        Aggregated shrinkage data for the activity category

        :param shrinkage_for_activity_category: The shrinkage_for_activity_category of this HistoricalShrinkageActivityCategoryResponse.
        :type: HistoricalShrinkageAggregateResponse
        """
        

        self._shrinkage_for_activity_category = shrinkage_for_activity_category

    @property
    def shrinkage_for_activity_codes(self) -> List['HistoricalShrinkageActivityCodeResponse']:
        """
        Gets the shrinkage_for_activity_codes of this HistoricalShrinkageActivityCategoryResponse.
        Shrinkage for the activity codes under this activity category

        :return: The shrinkage_for_activity_codes of this HistoricalShrinkageActivityCategoryResponse.
        :rtype: list[HistoricalShrinkageActivityCodeResponse]
        """
        return self._shrinkage_for_activity_codes

    @shrinkage_for_activity_codes.setter
    def shrinkage_for_activity_codes(self, shrinkage_for_activity_codes: List['HistoricalShrinkageActivityCodeResponse']) -> None:
        """
        Sets the shrinkage_for_activity_codes of this HistoricalShrinkageActivityCategoryResponse.
        Shrinkage for the activity codes under this activity category

        :param shrinkage_for_activity_codes: The shrinkage_for_activity_codes of this HistoricalShrinkageActivityCategoryResponse.
        :type: list[HistoricalShrinkageActivityCodeResponse]
        """
        

        self._shrinkage_for_activity_codes = shrinkage_for_activity_codes

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

