# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class IdleTokenTimeout(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        IdleTokenTimeout - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'idle_token_timeout_seconds': 'int',
            'enable_idle_token_timeout': 'bool'
        }

        self.attribute_map = {
            'idle_token_timeout_seconds': 'idleTokenTimeoutSeconds',
            'enable_idle_token_timeout': 'enableIdleTokenTimeout'
        }

        self._idle_token_timeout_seconds = None
        self._enable_idle_token_timeout = None

    @property
    def idle_token_timeout_seconds(self) -> int:
        """
        Gets the idle_token_timeout_seconds of this IdleTokenTimeout.
        Token timeout length in seconds. Must be at least 5 minutes and 8 hours or less (if HIPAA is disabled) or 15 minutes or less (if HIPAA is enabled).

        :return: The idle_token_timeout_seconds of this IdleTokenTimeout.
        :rtype: int
        """
        return self._idle_token_timeout_seconds

    @idle_token_timeout_seconds.setter
    def idle_token_timeout_seconds(self, idle_token_timeout_seconds: int) -> None:
        """
        Sets the idle_token_timeout_seconds of this IdleTokenTimeout.
        Token timeout length in seconds. Must be at least 5 minutes and 8 hours or less (if HIPAA is disabled) or 15 minutes or less (if HIPAA is enabled).

        :param idle_token_timeout_seconds: The idle_token_timeout_seconds of this IdleTokenTimeout.
        :type: int
        """
        
        if idle_token_timeout_seconds < 300:
            raise ValueError("Invalid value for `idle_token_timeout_seconds`, must be a value greater than or equal to `300`")


        self._idle_token_timeout_seconds = idle_token_timeout_seconds

    @property
    def enable_idle_token_timeout(self) -> bool:
        """
        Gets the enable_idle_token_timeout of this IdleTokenTimeout.
        Indicates whether the Token Timeout should be enabled or disabled.

        :return: The enable_idle_token_timeout of this IdleTokenTimeout.
        :rtype: bool
        """
        return self._enable_idle_token_timeout

    @enable_idle_token_timeout.setter
    def enable_idle_token_timeout(self, enable_idle_token_timeout: bool) -> None:
        """
        Sets the enable_idle_token_timeout of this IdleTokenTimeout.
        Indicates whether the Token Timeout should be enabled or disabled.

        :param enable_idle_token_timeout: The enable_idle_token_timeout of this IdleTokenTimeout.
        :type: bool
        """
        

        self._enable_idle_token_timeout = enable_idle_token_timeout

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

