# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DomainEntityRef
    from . import ImportStatus
    from . import SplittingInformation

class ImportTemplate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ImportTemplate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'version': 'int',
            'contact_list_template': 'DomainEntityRef',
            'contact_list_filter': 'DomainEntityRef',
            'use_splitting_criteria': 'bool',
            'splitting_information': 'SplittingInformation',
            'list_name_format': 'str',
            'custom_list_name_format_value': 'str',
            'import_status': 'ImportStatus',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'version': 'version',
            'contact_list_template': 'contactListTemplate',
            'contact_list_filter': 'contactListFilter',
            'use_splitting_criteria': 'useSplittingCriteria',
            'splitting_information': 'splittingInformation',
            'list_name_format': 'listNameFormat',
            'custom_list_name_format_value': 'customListNameFormatValue',
            'import_status': 'importStatus',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._date_created = None
        self._date_modified = None
        self._version = None
        self._contact_list_template = None
        self._contact_list_filter = None
        self._use_splitting_criteria = None
        self._splitting_information = None
        self._list_name_format = None
        self._custom_list_name_format_value = None
        self._import_status = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ImportTemplate.
        The globally unique identifier for the object.

        :return: The id of this ImportTemplate.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ImportTemplate.
        The globally unique identifier for the object.

        :param id: The id of this ImportTemplate.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this ImportTemplate.
        The name of the import template.

        :return: The name of this ImportTemplate.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this ImportTemplate.
        The name of the import template.

        :param name: The name of this ImportTemplate.
        :type: str
        """
        

        self._name = name

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this ImportTemplate.
        Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this ImportTemplate.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this ImportTemplate.
        Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this ImportTemplate.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this ImportTemplate.
        Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this ImportTemplate.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this ImportTemplate.
        Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this ImportTemplate.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def version(self) -> int:
        """
        Gets the version of this ImportTemplate.
        Required for updates, must match the version number of the most recent update

        :return: The version of this ImportTemplate.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this ImportTemplate.
        Required for updates, must match the version number of the most recent update

        :param version: The version of this ImportTemplate.
        :type: int
        """
        

        self._version = version

    @property
    def contact_list_template(self) -> 'DomainEntityRef':
        """
        Gets the contact_list_template of this ImportTemplate.
        ContactListTemplate for this ImportTemplate.

        :return: The contact_list_template of this ImportTemplate.
        :rtype: DomainEntityRef
        """
        return self._contact_list_template

    @contact_list_template.setter
    def contact_list_template(self, contact_list_template: 'DomainEntityRef') -> None:
        """
        Sets the contact_list_template of this ImportTemplate.
        ContactListTemplate for this ImportTemplate.

        :param contact_list_template: The contact_list_template of this ImportTemplate.
        :type: DomainEntityRef
        """
        

        self._contact_list_template = contact_list_template

    @property
    def contact_list_filter(self) -> 'DomainEntityRef':
        """
        Gets the contact_list_filter of this ImportTemplate.
        ContactListFilter for this ImportTemplate.

        :return: The contact_list_filter of this ImportTemplate.
        :rtype: DomainEntityRef
        """
        return self._contact_list_filter

    @contact_list_filter.setter
    def contact_list_filter(self, contact_list_filter: 'DomainEntityRef') -> None:
        """
        Sets the contact_list_filter of this ImportTemplate.
        ContactListFilter for this ImportTemplate.

        :param contact_list_filter: The contact_list_filter of this ImportTemplate.
        :type: DomainEntityRef
        """
        

        self._contact_list_filter = contact_list_filter

    @property
    def use_splitting_criteria(self) -> bool:
        """
        Gets the use_splitting_criteria of this ImportTemplate.
        Whether or not to use splitting criteria. Default is false.

        :return: The use_splitting_criteria of this ImportTemplate.
        :rtype: bool
        """
        return self._use_splitting_criteria

    @use_splitting_criteria.setter
    def use_splitting_criteria(self, use_splitting_criteria: bool) -> None:
        """
        Sets the use_splitting_criteria of this ImportTemplate.
        Whether or not to use splitting criteria. Default is false.

        :param use_splitting_criteria: The use_splitting_criteria of this ImportTemplate.
        :type: bool
        """
        

        self._use_splitting_criteria = use_splitting_criteria

    @property
    def splitting_information(self) -> 'SplittingInformation':
        """
        Gets the splitting_information of this ImportTemplate.
        How to split contact records, required if useSplittingCriteria is true.

        :return: The splitting_information of this ImportTemplate.
        :rtype: SplittingInformation
        """
        return self._splitting_information

    @splitting_information.setter
    def splitting_information(self, splitting_information: 'SplittingInformation') -> None:
        """
        Sets the splitting_information of this ImportTemplate.
        How to split contact records, required if useSplittingCriteria is true.

        :param splitting_information: The splitting_information of this ImportTemplate.
        :type: SplittingInformation
        """
        

        self._splitting_information = splitting_information

    @property
    def list_name_format(self) -> str:
        """
        Gets the list_name_format of this ImportTemplate.
        The list name format for target ContactLists. When Custom is provided, customListNameFormatValue is required.

        :return: The list_name_format of this ImportTemplate.
        :rtype: str
        """
        return self._list_name_format

    @list_name_format.setter
    def list_name_format(self, list_name_format: str) -> None:
        """
        Sets the list_name_format of this ImportTemplate.
        The list name format for target ContactLists. When Custom is provided, customListNameFormatValue is required.

        :param list_name_format: The list_name_format of this ImportTemplate.
        :type: str
        """
        if isinstance(list_name_format, int):
            list_name_format = str(list_name_format)
        allowed_values = ["ListNamePrefix", "ListNamePrefixMonthDayYear", "ListNamePrefixMonthDayYearHourMinuteSecond", "ListNamePrefixPart", "ListNamePrefixMonthDayYearPart", "ListNamePrefixMonthDayYearHourMinuteSecondPart", "Custom"]
        if list_name_format.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for list_name_format -> " + list_name_format)
            self._list_name_format = "outdated_sdk_version"
        else:
            self._list_name_format = list_name_format

    @property
    def custom_list_name_format_value(self) -> str:
        """
        Gets the custom_list_name_format_value of this ImportTemplate.
        Custom value for the list name format, at least %N is required. Any character other than the specified tokens will be used as is. Available tokens: %N: ListNamePrefix; %P: Part number; %F: Filter name; %C: Column value; YYYY: year; MM: month; DD: day; hh: hour; mm: minute; ss: second.

        :return: The custom_list_name_format_value of this ImportTemplate.
        :rtype: str
        """
        return self._custom_list_name_format_value

    @custom_list_name_format_value.setter
    def custom_list_name_format_value(self, custom_list_name_format_value: str) -> None:
        """
        Sets the custom_list_name_format_value of this ImportTemplate.
        Custom value for the list name format, at least %N is required. Any character other than the specified tokens will be used as is. Available tokens: %N: ListNamePrefix; %P: Part number; %F: Filter name; %C: Column value; YYYY: year; MM: month; DD: day; hh: hour; mm: minute; ss: second.

        :param custom_list_name_format_value: The custom_list_name_format_value of this ImportTemplate.
        :type: str
        """
        

        self._custom_list_name_format_value = custom_list_name_format_value

    @property
    def import_status(self) -> 'ImportStatus':
        """
        Gets the import_status of this ImportTemplate.
        The status of the import process.

        :return: The import_status of this ImportTemplate.
        :rtype: ImportStatus
        """
        return self._import_status

    @import_status.setter
    def import_status(self, import_status: 'ImportStatus') -> None:
        """
        Sets the import_status of this ImportTemplate.
        The status of the import process.

        :param import_status: The import_status of this ImportTemplate.
        :type: ImportStatus
        """
        

        self._import_status = import_status

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ImportTemplate.
        The URI for this object

        :return: The self_uri of this ImportTemplate.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ImportTemplate.
        The URI for this object

        :param self_uri: The self_uri of this ImportTemplate.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

