# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DomainEntityRef
    from . import ImapSettings
    from . import MailFromResult

class InboundDomainPatchRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        InboundDomainPatchRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'mail_from_settings': 'MailFromResult',
            'custom_smtp_server': 'DomainEntityRef',
            'imap_settings': 'ImapSettings'
        }

        self.attribute_map = {
            'mail_from_settings': 'mailFromSettings',
            'custom_smtp_server': 'customSMTPServer',
            'imap_settings': 'imapSettings'
        }

        self._mail_from_settings = None
        self._custom_smtp_server = None
        self._imap_settings = None

    @property
    def mail_from_settings(self) -> 'MailFromResult':
        """
        Gets the mail_from_settings of this InboundDomainPatchRequest.
        The DNS settings if the inbound domain is using a custom Mail From. These settings can only be used on InboundDomains where subDomain is false.

        :return: The mail_from_settings of this InboundDomainPatchRequest.
        :rtype: MailFromResult
        """
        return self._mail_from_settings

    @mail_from_settings.setter
    def mail_from_settings(self, mail_from_settings: 'MailFromResult') -> None:
        """
        Sets the mail_from_settings of this InboundDomainPatchRequest.
        The DNS settings if the inbound domain is using a custom Mail From. These settings can only be used on InboundDomains where subDomain is false.

        :param mail_from_settings: The mail_from_settings of this InboundDomainPatchRequest.
        :type: MailFromResult
        """
        

        self._mail_from_settings = mail_from_settings

    @property
    def custom_smtp_server(self) -> 'DomainEntityRef':
        """
        Gets the custom_smtp_server of this InboundDomainPatchRequest.
        The custom SMTP server integration to use when sending outbound emails from this domain.

        :return: The custom_smtp_server of this InboundDomainPatchRequest.
        :rtype: DomainEntityRef
        """
        return self._custom_smtp_server

    @custom_smtp_server.setter
    def custom_smtp_server(self, custom_smtp_server: 'DomainEntityRef') -> None:
        """
        Sets the custom_smtp_server of this InboundDomainPatchRequest.
        The custom SMTP server integration to use when sending outbound emails from this domain.

        :param custom_smtp_server: The custom_smtp_server of this InboundDomainPatchRequest.
        :type: DomainEntityRef
        """
        

        self._custom_smtp_server = custom_smtp_server

    @property
    def imap_settings(self) -> 'ImapSettings':
        """
        Gets the imap_settings of this InboundDomainPatchRequest.
        The IMAP server integration and settings to use for processing inbound emails.

        :return: The imap_settings of this InboundDomainPatchRequest.
        :rtype: ImapSettings
        """
        return self._imap_settings

    @imap_settings.setter
    def imap_settings(self, imap_settings: 'ImapSettings') -> None:
        """
        Sets the imap_settings of this InboundDomainPatchRequest.
        The IMAP server integration and settings to use for processing inbound emails.

        :param imap_settings: The imap_settings of this InboundDomainPatchRequest.
        :type: ImapSettings
        """
        

        self._imap_settings = imap_settings

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

