# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import InputMessage

class IncomingMessageRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        IncomingMessageRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'bot_id': 'str',
            'bot_name': 'str',
            'bot_version': 'str',
            'integration_id': 'str',
            'bot_session_id': 'str',
            'automate_flow_exec_id': 'str',
            'conversation_id': 'str',
            'language_code': 'str',
            'input_message': 'InputMessage',
            'messaging_platform_type': 'str',
            'channels': 'list[str]',
            'bot_session_timeout': 'int',
            'parameters': 'dict(str, str)'
        }

        self.attribute_map = {
            'bot_id': 'botId',
            'bot_name': 'botName',
            'bot_version': 'botVersion',
            'integration_id': 'integrationId',
            'bot_session_id': 'botSessionId',
            'automate_flow_exec_id': 'automateFlowExecId',
            'conversation_id': 'conversationId',
            'language_code': 'languageCode',
            'input_message': 'inputMessage',
            'messaging_platform_type': 'messagingPlatformType',
            'channels': 'channels',
            'bot_session_timeout': 'botSessionTimeout',
            'parameters': 'parameters'
        }

        self._bot_id = None
        self._bot_name = None
        self._bot_version = None
        self._integration_id = None
        self._bot_session_id = None
        self._automate_flow_exec_id = None
        self._conversation_id = None
        self._language_code = None
        self._input_message = None
        self._messaging_platform_type = None
        self._channels = None
        self._bot_session_timeout = None
        self._parameters = None

    @property
    def bot_id(self) -> str:
        """
        Gets the bot_id of this IncomingMessageRequest.
        The unique id of the bot.

        :return: The bot_id of this IncomingMessageRequest.
        :rtype: str
        """
        return self._bot_id

    @bot_id.setter
    def bot_id(self, bot_id: str) -> None:
        """
        Sets the bot_id of this IncomingMessageRequest.
        The unique id of the bot.

        :param bot_id: The bot_id of this IncomingMessageRequest.
        :type: str
        """
        

        self._bot_id = bot_id

    @property
    def bot_name(self) -> str:
        """
        Gets the bot_name of this IncomingMessageRequest.
        Name of the bot

        :return: The bot_name of this IncomingMessageRequest.
        :rtype: str
        """
        return self._bot_name

    @bot_name.setter
    def bot_name(self, bot_name: str) -> None:
        """
        Sets the bot_name of this IncomingMessageRequest.
        Name of the bot

        :param bot_name: The bot_name of this IncomingMessageRequest.
        :type: str
        """
        

        self._bot_name = bot_name

    @property
    def bot_version(self) -> str:
        """
        Gets the bot_version of this IncomingMessageRequest.
        The version of the bot.

        :return: The bot_version of this IncomingMessageRequest.
        :rtype: str
        """
        return self._bot_version

    @bot_version.setter
    def bot_version(self, bot_version: str) -> None:
        """
        Sets the bot_version of this IncomingMessageRequest.
        The version of the bot.

        :param bot_version: The bot_version of this IncomingMessageRequest.
        :type: str
        """
        

        self._bot_version = bot_version

    @property
    def integration_id(self) -> str:
        """
        Gets the integration_id of this IncomingMessageRequest.
        The Integration Id for the bot's configuration

        :return: The integration_id of this IncomingMessageRequest.
        :rtype: str
        """
        return self._integration_id

    @integration_id.setter
    def integration_id(self, integration_id: str) -> None:
        """
        Sets the integration_id of this IncomingMessageRequest.
        The Integration Id for the bot's configuration

        :param integration_id: The integration_id of this IncomingMessageRequest.
        :type: str
        """
        

        self._integration_id = integration_id

    @property
    def bot_session_id(self) -> str:
        """
        Gets the bot_session_id of this IncomingMessageRequest.
        The id of the session. This id will be used for an entire conversation with the bot (a series of back and forth between the bot until the bot has fulfilled its intent).

        :return: The bot_session_id of this IncomingMessageRequest.
        :rtype: str
        """
        return self._bot_session_id

    @bot_session_id.setter
    def bot_session_id(self, bot_session_id: str) -> None:
        """
        Sets the bot_session_id of this IncomingMessageRequest.
        The id of the session. This id will be used for an entire conversation with the bot (a series of back and forth between the bot until the bot has fulfilled its intent).

        :param bot_session_id: The bot_session_id of this IncomingMessageRequest.
        :type: str
        """
        

        self._bot_session_id = bot_session_id

    @property
    def automate_flow_exec_id(self) -> str:
        """
        Gets the automate_flow_exec_id of this IncomingMessageRequest.
        Execution ID of the Automate Flow.

        :return: The automate_flow_exec_id of this IncomingMessageRequest.
        :rtype: str
        """
        return self._automate_flow_exec_id

    @automate_flow_exec_id.setter
    def automate_flow_exec_id(self, automate_flow_exec_id: str) -> None:
        """
        Sets the automate_flow_exec_id of this IncomingMessageRequest.
        Execution ID of the Automate Flow.

        :param automate_flow_exec_id: The automate_flow_exec_id of this IncomingMessageRequest.
        :type: str
        """
        

        self._automate_flow_exec_id = automate_flow_exec_id

    @property
    def conversation_id(self) -> str:
        """
        Gets the conversation_id of this IncomingMessageRequest.
        Genesys conversation ID.

        :return: The conversation_id of this IncomingMessageRequest.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id: str) -> None:
        """
        Sets the conversation_id of this IncomingMessageRequest.
        Genesys conversation ID.

        :param conversation_id: The conversation_id of this IncomingMessageRequest.
        :type: str
        """
        

        self._conversation_id = conversation_id

    @property
    def language_code(self) -> str:
        """
        Gets the language_code of this IncomingMessageRequest.
        Language code for the conversation (e.g., 'en-US').

        :return: The language_code of this IncomingMessageRequest.
        :rtype: str
        """
        return self._language_code

    @language_code.setter
    def language_code(self, language_code: str) -> None:
        """
        Sets the language_code of this IncomingMessageRequest.
        Language code for the conversation (e.g., 'en-US').

        :param language_code: The language_code of this IncomingMessageRequest.
        :type: str
        """
        

        self._language_code = language_code

    @property
    def input_message(self) -> 'InputMessage':
        """
        Gets the input_message of this IncomingMessageRequest.
        Message received from the user to send to the bot

        :return: The input_message of this IncomingMessageRequest.
        :rtype: InputMessage
        """
        return self._input_message

    @input_message.setter
    def input_message(self, input_message: 'InputMessage') -> None:
        """
        Sets the input_message of this IncomingMessageRequest.
        Message received from the user to send to the bot

        :param input_message: The input_message of this IncomingMessageRequest.
        :type: InputMessage
        """
        

        self._input_message = input_message

    @property
    def messaging_platform_type(self) -> str:
        """
        Gets the messaging_platform_type of this IncomingMessageRequest.
        Type of messaging platform being used

        :return: The messaging_platform_type of this IncomingMessageRequest.
        :rtype: str
        """
        return self._messaging_platform_type

    @messaging_platform_type.setter
    def messaging_platform_type(self, messaging_platform_type: str) -> None:
        """
        Sets the messaging_platform_type of this IncomingMessageRequest.
        Type of messaging platform being used

        :param messaging_platform_type: The messaging_platform_type of this IncomingMessageRequest.
        :type: str
        """
        if isinstance(messaging_platform_type, int):
            messaging_platform_type = str(messaging_platform_type)
        allowed_values = ["Phone", "SMS", "GenesysWebWidget", "FacebookMessenger", "WeChat", "Whatsapp", "AppleBusinessChat", "Apple", "Telegram", "Slack", "Signal", "Line", "Discord", "TwitterDirectMessage", "Open", "Instagram", "Other", "Unknown"]
        if messaging_platform_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for messaging_platform_type -> " + messaging_platform_type)
            self._messaging_platform_type = "outdated_sdk_version"
        else:
            self._messaging_platform_type = messaging_platform_type

    @property
    def channels(self) -> List[str]:
        """
        Gets the channels of this IncomingMessageRequest.
        The channels this bot is utilizing.

        :return: The channels of this IncomingMessageRequest.
        :rtype: list[str]
        """
        return self._channels

    @channels.setter
    def channels(self, channels: List[str]) -> None:
        """
        Sets the channels of this IncomingMessageRequest.
        The channels this bot is utilizing.

        :param channels: The channels of this IncomingMessageRequest.
        :type: list[str]
        """
        

        self._channels = channels

    @property
    def bot_session_timeout(self) -> int:
        """
        Gets the bot_session_timeout of this IncomingMessageRequest.
        Timeout duration for bot session in minutes.

        :return: The bot_session_timeout of this IncomingMessageRequest.
        :rtype: int
        """
        return self._bot_session_timeout

    @bot_session_timeout.setter
    def bot_session_timeout(self, bot_session_timeout: int) -> None:
        """
        Sets the bot_session_timeout of this IncomingMessageRequest.
        Timeout duration for bot session in minutes.

        :param bot_session_timeout: The bot_session_timeout of this IncomingMessageRequest.
        :type: int
        """
        

        self._bot_session_timeout = bot_session_timeout

    @property
    def parameters(self) -> Dict[str, str]:
        """
        Gets the parameters of this IncomingMessageRequest.
        This is a map of string-string key, value pairs containing optional fields that can be passed to the bot for custom behavior, tracking, etc.

        :return: The parameters of this IncomingMessageRequest.
        :rtype: dict(str, str)
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters: Dict[str, str]) -> None:
        """
        Sets the parameters of this IncomingMessageRequest.
        This is a map of string-string key, value pairs containing optional fields that can be passed to the bot for custom behavior, tracking, etc.

        :param parameters: The parameters of this IncomingMessageRequest.
        :type: dict(str, str)
        """
        

        self._parameters = parameters

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

