# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class Input(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Input - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'title': 'str',
            'subtitle': 'str',
            'placeholder_text': 'str',
            'is_multiple_line': 'bool',
            'is_required': 'bool'
        }

        self.attribute_map = {
            'id': 'id',
            'title': 'title',
            'subtitle': 'subtitle',
            'placeholder_text': 'placeholderText',
            'is_multiple_line': 'isMultipleLine',
            'is_required': 'isRequired'
        }

        self._id = None
        self._title = None
        self._subtitle = None
        self._placeholder_text = None
        self._is_multiple_line = None
        self._is_required = None

    @property
    def id(self) -> str:
        """
        Gets the id of this Input.
        Unique identifier for the input field

        :return: The id of this Input.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this Input.
        Unique identifier for the input field

        :param id: The id of this Input.
        :type: str
        """
        

        self._id = id

    @property
    def title(self) -> str:
        """
        Gets the title of this Input.
        Title of the input field

        :return: The title of this Input.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this Input.
        Title of the input field

        :param title: The title of this Input.
        :type: str
        """
        

        self._title = title

    @property
    def subtitle(self) -> str:
        """
        Gets the subtitle of this Input.
        Subtitle of the input field

        :return: The subtitle of this Input.
        :rtype: str
        """
        return self._subtitle

    @subtitle.setter
    def subtitle(self, subtitle: str) -> None:
        """
        Sets the subtitle of this Input.
        Subtitle of the input field

        :param subtitle: The subtitle of this Input.
        :type: str
        """
        

        self._subtitle = subtitle

    @property
    def placeholder_text(self) -> str:
        """
        Gets the placeholder_text of this Input.
        Placeholder text for the input

        :return: The placeholder_text of this Input.
        :rtype: str
        """
        return self._placeholder_text

    @placeholder_text.setter
    def placeholder_text(self, placeholder_text: str) -> None:
        """
        Sets the placeholder_text of this Input.
        Placeholder text for the input

        :param placeholder_text: The placeholder_text of this Input.
        :type: str
        """
        

        self._placeholder_text = placeholder_text

    @property
    def is_multiple_line(self) -> bool:
        """
        Gets the is_multiple_line of this Input.
        Whether the input supports multiple lines

        :return: The is_multiple_line of this Input.
        :rtype: bool
        """
        return self._is_multiple_line

    @is_multiple_line.setter
    def is_multiple_line(self, is_multiple_line: bool) -> None:
        """
        Sets the is_multiple_line of this Input.
        Whether the input supports multiple lines

        :param is_multiple_line: The is_multiple_line of this Input.
        :type: bool
        """
        

        self._is_multiple_line = is_multiple_line

    @property
    def is_required(self) -> bool:
        """
        Gets the is_required of this Input.
        Whether the input is required

        :return: The is_required of this Input.
        :rtype: bool
        """
        return self._is_required

    @is_required.setter
    def is_required(self, is_required: bool) -> None:
        """
        Sets the is_required of this Input.
        Whether the input is required

        :param is_required: The is_required of this Input.
        :type: bool
        """
        

        self._is_required = is_required

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

