# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class InsightsDetailsMetricPeriodPoints(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        InsightsDetailsMetricPeriodPoints - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'points': 'int',
            'max_points': 'int',
            'data_point_count': 'int',
            'percent_of_goal': 'float',
            'rank_total_points': 'int',
            'rank_percentage_points': 'int',
            'value': 'float'
        }

        self.attribute_map = {
            'points': 'points',
            'max_points': 'maxPoints',
            'data_point_count': 'dataPointCount',
            'percent_of_goal': 'percentOfGoal',
            'rank_total_points': 'rankTotalPoints',
            'rank_percentage_points': 'rankPercentagePoints',
            'value': 'value'
        }

        self._points = None
        self._max_points = None
        self._data_point_count = None
        self._percent_of_goal = None
        self._rank_total_points = None
        self._rank_percentage_points = None
        self._value = None

    @property
    def points(self) -> int:
        """
        Gets the points of this InsightsDetailsMetricPeriodPoints.
        Points scored

        :return: The points of this InsightsDetailsMetricPeriodPoints.
        :rtype: int
        """
        return self._points

    @points.setter
    def points(self, points: int) -> None:
        """
        Sets the points of this InsightsDetailsMetricPeriodPoints.
        Points scored

        :param points: The points of this InsightsDetailsMetricPeriodPoints.
        :type: int
        """
        

        self._points = points

    @property
    def max_points(self) -> int:
        """
        Gets the max_points of this InsightsDetailsMetricPeriodPoints.
        Max possible points

        :return: The max_points of this InsightsDetailsMetricPeriodPoints.
        :rtype: int
        """
        return self._max_points

    @max_points.setter
    def max_points(self, max_points: int) -> None:
        """
        Sets the max_points of this InsightsDetailsMetricPeriodPoints.
        Max possible points

        :param max_points: The max_points of this InsightsDetailsMetricPeriodPoints.
        :type: int
        """
        

        self._max_points = max_points

    @property
    def data_point_count(self) -> int:
        """
        Gets the data_point_count of this InsightsDetailsMetricPeriodPoints.
        Number of data points

        :return: The data_point_count of this InsightsDetailsMetricPeriodPoints.
        :rtype: int
        """
        return self._data_point_count

    @data_point_count.setter
    def data_point_count(self, data_point_count: int) -> None:
        """
        Sets the data_point_count of this InsightsDetailsMetricPeriodPoints.
        Number of data points

        :param data_point_count: The data_point_count of this InsightsDetailsMetricPeriodPoints.
        :type: int
        """
        

        self._data_point_count = data_point_count

    @property
    def percent_of_goal(self) -> float:
        """
        Gets the percent_of_goal of this InsightsDetailsMetricPeriodPoints.
        Percentage of the goal

        :return: The percent_of_goal of this InsightsDetailsMetricPeriodPoints.
        :rtype: float
        """
        return self._percent_of_goal

    @percent_of_goal.setter
    def percent_of_goal(self, percent_of_goal: float) -> None:
        """
        Sets the percent_of_goal of this InsightsDetailsMetricPeriodPoints.
        Percentage of the goal

        :param percent_of_goal: The percent_of_goal of this InsightsDetailsMetricPeriodPoints.
        :type: float
        """
        

        self._percent_of_goal = percent_of_goal

    @property
    def rank_total_points(self) -> int:
        """
        Gets the rank_total_points of this InsightsDetailsMetricPeriodPoints.
        The agent's rank in leader board for points on this metric

        :return: The rank_total_points of this InsightsDetailsMetricPeriodPoints.
        :rtype: int
        """
        return self._rank_total_points

    @rank_total_points.setter
    def rank_total_points(self, rank_total_points: int) -> None:
        """
        Sets the rank_total_points of this InsightsDetailsMetricPeriodPoints.
        The agent's rank in leader board for points on this metric

        :param rank_total_points: The rank_total_points of this InsightsDetailsMetricPeriodPoints.
        :type: int
        """
        

        self._rank_total_points = rank_total_points

    @property
    def rank_percentage_points(self) -> int:
        """
        Gets the rank_percentage_points of this InsightsDetailsMetricPeriodPoints.
        The agent's rank in leader board for percentage on this metric

        :return: The rank_percentage_points of this InsightsDetailsMetricPeriodPoints.
        :rtype: int
        """
        return self._rank_percentage_points

    @rank_percentage_points.setter
    def rank_percentage_points(self, rank_percentage_points: int) -> None:
        """
        Sets the rank_percentage_points of this InsightsDetailsMetricPeriodPoints.
        The agent's rank in leader board for percentage on this metric

        :param rank_percentage_points: The rank_percentage_points of this InsightsDetailsMetricPeriodPoints.
        :type: int
        """
        

        self._rank_percentage_points = rank_percentage_points

    @property
    def value(self) -> float:
        """
        Gets the value of this InsightsDetailsMetricPeriodPoints.
        Average value

        :return: The value of this InsightsDetailsMetricPeriodPoints.
        :rtype: float
        """
        return self._value

    @value.setter
    def value(self, value: float) -> None:
        """
        Sets the value of this InsightsDetailsMetricPeriodPoints.
        Average value

        :param value: The value of this InsightsDetailsMetricPeriodPoints.
        :type: float
        """
        

        self._value = value

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

