# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DetectedNamedEntity

class IntentFeedback(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        IntentFeedback - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'probability': 'float',
            'entities': 'list[DetectedNamedEntity]',
            'assessment': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'probability': 'probability',
            'entities': 'entities',
            'assessment': 'assessment'
        }

        self._name = None
        self._probability = None
        self._entities = None
        self._assessment = None

    @property
    def name(self) -> str:
        """
        Gets the name of this IntentFeedback.
        The name of the detected intent.

        :return: The name of this IntentFeedback.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this IntentFeedback.
        The name of the detected intent.

        :param name: The name of this IntentFeedback.
        :type: str
        """
        

        self._name = name

    @property
    def probability(self) -> float:
        """
        Gets the probability of this IntentFeedback.
        The probability of the detected intent.

        :return: The probability of this IntentFeedback.
        :rtype: float
        """
        return self._probability

    @probability.setter
    def probability(self, probability: float) -> None:
        """
        Sets the probability of this IntentFeedback.
        The probability of the detected intent.

        :param probability: The probability of this IntentFeedback.
        :type: float
        """
        

        self._probability = probability

    @property
    def entities(self) -> List['DetectedNamedEntity']:
        """
        Gets the entities of this IntentFeedback.
        The collection of named entities detected.

        :return: The entities of this IntentFeedback.
        :rtype: list[DetectedNamedEntity]
        """
        return self._entities

    @entities.setter
    def entities(self, entities: List['DetectedNamedEntity']) -> None:
        """
        Sets the entities of this IntentFeedback.
        The collection of named entities detected.

        :param entities: The entities of this IntentFeedback.
        :type: list[DetectedNamedEntity]
        """
        

        self._entities = entities

    @property
    def assessment(self) -> str:
        """
        Gets the assessment of this IntentFeedback.
        The assessment on the detection for feedback text.

        :return: The assessment of this IntentFeedback.
        :rtype: str
        """
        return self._assessment

    @assessment.setter
    def assessment(self, assessment: str) -> None:
        """
        Sets the assessment of this IntentFeedback.
        The assessment on the detection for feedback text.

        :param assessment: The assessment of this IntentFeedback.
        :type: str
        """
        if isinstance(assessment, int):
            assessment = str(assessment)
        allowed_values = ["Incorrect", "Correct", "Unknown", "Disabled"]
        if assessment.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for assessment -> " + assessment)
            self._assessment = "outdated_sdk_version"
        else:
            self._assessment = assessment

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

