# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import ConversationNormalizedMessage
    from . import UserReference

class InternalMessageData(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        InternalMessageData - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'conversation': 'AddressableEntityRef',
            'communication_id': 'str',
            'timestamp': 'datetime',
            'sender': 'UserReference',
            'recipient': 'UserReference',
            'normalized_message': 'ConversationNormalizedMessage',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'conversation': 'conversation',
            'communication_id': 'communicationId',
            'timestamp': 'timestamp',
            'sender': 'sender',
            'recipient': 'recipient',
            'normalized_message': 'normalizedMessage',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._conversation = None
        self._communication_id = None
        self._timestamp = None
        self._sender = None
        self._recipient = None
        self._normalized_message = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this InternalMessageData.
        The globally unique identifier for the object.

        :return: The id of this InternalMessageData.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this InternalMessageData.
        The globally unique identifier for the object.

        :param id: The id of this InternalMessageData.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this InternalMessageData.


        :return: The name of this InternalMessageData.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this InternalMessageData.


        :param name: The name of this InternalMessageData.
        :type: str
        """
        

        self._name = name

    @property
    def conversation(self) -> 'AddressableEntityRef':
        """
        Gets the conversation of this InternalMessageData.
        The conversation of this message.

        :return: The conversation of this InternalMessageData.
        :rtype: AddressableEntityRef
        """
        return self._conversation

    @conversation.setter
    def conversation(self, conversation: 'AddressableEntityRef') -> None:
        """
        Sets the conversation of this InternalMessageData.
        The conversation of this message.

        :param conversation: The conversation of this InternalMessageData.
        :type: AddressableEntityRef
        """
        

        self._conversation = conversation

    @property
    def communication_id(self) -> str:
        """
        Gets the communication_id of this InternalMessageData.
        The id of the communication of this message.

        :return: The communication_id of this InternalMessageData.
        :rtype: str
        """
        return self._communication_id

    @communication_id.setter
    def communication_id(self, communication_id: str) -> None:
        """
        Sets the communication_id of this InternalMessageData.
        The id of the communication of this message.

        :param communication_id: The communication_id of this InternalMessageData.
        :type: str
        """
        

        self._communication_id = communication_id

    @property
    def timestamp(self) -> datetime:
        """
        Gets the timestamp of this InternalMessageData.
        The time when the message was received or sent. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The timestamp of this InternalMessageData.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp: datetime) -> None:
        """
        Sets the timestamp of this InternalMessageData.
        The time when the message was received or sent. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param timestamp: The timestamp of this InternalMessageData.
        :type: datetime
        """
        

        self._timestamp = timestamp

    @property
    def sender(self) -> 'UserReference':
        """
        Gets the sender of this InternalMessageData.
        The sender of the text message.

        :return: The sender of this InternalMessageData.
        :rtype: UserReference
        """
        return self._sender

    @sender.setter
    def sender(self, sender: 'UserReference') -> None:
        """
        Sets the sender of this InternalMessageData.
        The sender of the text message.

        :param sender: The sender of this InternalMessageData.
        :type: UserReference
        """
        

        self._sender = sender

    @property
    def recipient(self) -> 'UserReference':
        """
        Gets the recipient of this InternalMessageData.
        The recipient of the text message.

        :return: The recipient of this InternalMessageData.
        :rtype: UserReference
        """
        return self._recipient

    @recipient.setter
    def recipient(self, recipient: 'UserReference') -> None:
        """
        Sets the recipient of this InternalMessageData.
        The recipient of the text message.

        :param recipient: The recipient of this InternalMessageData.
        :type: UserReference
        """
        

        self._recipient = recipient

    @property
    def normalized_message(self) -> 'ConversationNormalizedMessage':
        """
        Gets the normalized_message of this InternalMessageData.
        The message into normalized format

        :return: The normalized_message of this InternalMessageData.
        :rtype: ConversationNormalizedMessage
        """
        return self._normalized_message

    @normalized_message.setter
    def normalized_message(self, normalized_message: 'ConversationNormalizedMessage') -> None:
        """
        Sets the normalized_message of this InternalMessageData.
        The message into normalized format

        :param normalized_message: The normalized_message of this InternalMessageData.
        :type: ConversationNormalizedMessage
        """
        

        self._normalized_message = normalized_message

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this InternalMessageData.
        The URI for this object

        :return: The self_uri of this InternalMessageData.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this InternalMessageData.
        The URI for this object

        :param self_uri: The self_uri of this InternalMessageData.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

