# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class InvoiceAddress(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        InvoiceAddress - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'getdate_effective': 'date',
            'address_type': 'str',
            'currency_iso_code': 'str',
            'line1': 'str',
            'line2': 'str',
            'line3': 'str',
            'city_name': 'str',
            'postal_code': 'str',
            'state_code': 'str',
            'country_code': 'str',
            'getcity_subdivision1': 'str',
            'region_subdivision1': 'str',
            'region_subdivision2': 'str',
            'country': 'str'
        }

        self.attribute_map = {
            'getdate_effective': 'getdateEffective',
            'address_type': 'addressType',
            'currency_iso_code': 'currencyIsoCode',
            'line1': 'line1',
            'line2': 'line2',
            'line3': 'line3',
            'city_name': 'cityName',
            'postal_code': 'postalCode',
            'state_code': 'stateCode',
            'country_code': 'countryCode',
            'getcity_subdivision1': 'getcitySubdivision1',
            'region_subdivision1': 'regionSubdivision1',
            'region_subdivision2': 'regionSubdivision2',
            'country': 'country'
        }

        self._getdate_effective = None
        self._address_type = None
        self._currency_iso_code = None
        self._line1 = None
        self._line2 = None
        self._line3 = None
        self._city_name = None
        self._postal_code = None
        self._state_code = None
        self._country_code = None
        self._getcity_subdivision1 = None
        self._region_subdivision1 = None
        self._region_subdivision2 = None
        self._country = None

    @property
    def getdate_effective(self) -> date:
        """
        Gets the getdate_effective of this InvoiceAddress.
        The date when the Address became effective. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The getdate_effective of this InvoiceAddress.
        :rtype: date
        """
        return self._getdate_effective

    @getdate_effective.setter
    def getdate_effective(self, getdate_effective: date) -> None:
        """
        Sets the getdate_effective of this InvoiceAddress.
        The date when the Address became effective. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param getdate_effective: The getdate_effective of this InvoiceAddress.
        :type: date
        """
        

        self._getdate_effective = getdate_effective

    @property
    def address_type(self) -> str:
        """
        Gets the address_type of this InvoiceAddress.
        The type of address.

        :return: The address_type of this InvoiceAddress.
        :rtype: str
        """
        return self._address_type

    @address_type.setter
    def address_type(self, address_type: str) -> None:
        """
        Sets the address_type of this InvoiceAddress.
        The type of address.

        :param address_type: The address_type of this InvoiceAddress.
        :type: str
        """
        if isinstance(address_type, int):
            address_type = str(address_type)
        allowed_values = ["BillTo", "ShipTo", "EndUser", "SoldTo"]
        if address_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for address_type -> " + address_type)
            self._address_type = "outdated_sdk_version"
        else:
            self._address_type = address_type

    @property
    def currency_iso_code(self) -> str:
        """
        Gets the currency_iso_code of this InvoiceAddress.
        Contains the ISO code for any currency allowed by the organization.

        :return: The currency_iso_code of this InvoiceAddress.
        :rtype: str
        """
        return self._currency_iso_code

    @currency_iso_code.setter
    def currency_iso_code(self, currency_iso_code: str) -> None:
        """
        Sets the currency_iso_code of this InvoiceAddress.
        Contains the ISO code for any currency allowed by the organization.

        :param currency_iso_code: The currency_iso_code of this InvoiceAddress.
        :type: str
        """
        

        self._currency_iso_code = currency_iso_code

    @property
    def line1(self) -> str:
        """
        Gets the line1 of this InvoiceAddress.
        The first line of the Address.

        :return: The line1 of this InvoiceAddress.
        :rtype: str
        """
        return self._line1

    @line1.setter
    def line1(self, line1: str) -> None:
        """
        Sets the line1 of this InvoiceAddress.
        The first line of the Address.

        :param line1: The line1 of this InvoiceAddress.
        :type: str
        """
        

        self._line1 = line1

    @property
    def line2(self) -> str:
        """
        Gets the line2 of this InvoiceAddress.
        The second line of the Address.

        :return: The line2 of this InvoiceAddress.
        :rtype: str
        """
        return self._line2

    @line2.setter
    def line2(self, line2: str) -> None:
        """
        Sets the line2 of this InvoiceAddress.
        The second line of the Address.

        :param line2: The line2 of this InvoiceAddress.
        :type: str
        """
        

        self._line2 = line2

    @property
    def line3(self) -> str:
        """
        Gets the line3 of this InvoiceAddress.
        The third line of the Address.

        :return: The line3 of this InvoiceAddress.
        :rtype: str
        """
        return self._line3

    @line3.setter
    def line3(self, line3: str) -> None:
        """
        Sets the line3 of this InvoiceAddress.
        The third line of the Address.

        :param line3: The line3 of this InvoiceAddress.
        :type: str
        """
        

        self._line3 = line3

    @property
    def city_name(self) -> str:
        """
        Gets the city_name of this InvoiceAddress.
        The city name.

        :return: The city_name of this InvoiceAddress.
        :rtype: str
        """
        return self._city_name

    @city_name.setter
    def city_name(self, city_name: str) -> None:
        """
        Sets the city_name of this InvoiceAddress.
        The city name.

        :param city_name: The city_name of this InvoiceAddress.
        :type: str
        """
        

        self._city_name = city_name

    @property
    def postal_code(self) -> str:
        """
        Gets the postal_code of this InvoiceAddress.
        The Postal or Zip Code.

        :return: The postal_code of this InvoiceAddress.
        :rtype: str
        """
        return self._postal_code

    @postal_code.setter
    def postal_code(self, postal_code: str) -> None:
        """
        Sets the postal_code of this InvoiceAddress.
        The Postal or Zip Code.

        :param postal_code: The postal_code of this InvoiceAddress.
        :type: str
        """
        

        self._postal_code = postal_code

    @property
    def state_code(self) -> str:
        """
        Gets the state_code of this InvoiceAddress.
        The code that reflects the geographic state for the Address.

        :return: The state_code of this InvoiceAddress.
        :rtype: str
        """
        return self._state_code

    @state_code.setter
    def state_code(self, state_code: str) -> None:
        """
        Sets the state_code of this InvoiceAddress.
        The code that reflects the geographic state for the Address.

        :param state_code: The state_code of this InvoiceAddress.
        :type: str
        """
        

        self._state_code = state_code

    @property
    def country_code(self) -> str:
        """
        Gets the country_code of this InvoiceAddress.
        The code representing the country for the Address (ISO_3166).

        :return: The country_code of this InvoiceAddress.
        :rtype: str
        """
        return self._country_code

    @country_code.setter
    def country_code(self, country_code: str) -> None:
        """
        Sets the country_code of this InvoiceAddress.
        The code representing the country for the Address (ISO_3166).

        :param country_code: The country_code of this InvoiceAddress.
        :type: str
        """
        

        self._country_code = country_code

    @property
    def getcity_subdivision1(self) -> str:
        """
        Gets the getcity_subdivision1 of this InvoiceAddress.
        The primary subdivision within a city (e.g., district, neighborhood).

        :return: The getcity_subdivision1 of this InvoiceAddress.
        :rtype: str
        """
        return self._getcity_subdivision1

    @getcity_subdivision1.setter
    def getcity_subdivision1(self, getcity_subdivision1: str) -> None:
        """
        Sets the getcity_subdivision1 of this InvoiceAddress.
        The primary subdivision within a city (e.g., district, neighborhood).

        :param getcity_subdivision1: The getcity_subdivision1 of this InvoiceAddress.
        :type: str
        """
        

        self._getcity_subdivision1 = getcity_subdivision1

    @property
    def region_subdivision1(self) -> str:
        """
        Gets the region_subdivision1 of this InvoiceAddress.
        The primary administrative division within a region (e.g., state, province).

        :return: The region_subdivision1 of this InvoiceAddress.
        :rtype: str
        """
        return self._region_subdivision1

    @region_subdivision1.setter
    def region_subdivision1(self, region_subdivision1: str) -> None:
        """
        Sets the region_subdivision1 of this InvoiceAddress.
        The primary administrative division within a region (e.g., state, province).

        :param region_subdivision1: The region_subdivision1 of this InvoiceAddress.
        :type: str
        """
        

        self._region_subdivision1 = region_subdivision1

    @property
    def region_subdivision2(self) -> str:
        """
        Gets the region_subdivision2 of this InvoiceAddress.
        A secondary subdivision within the primary region subdivision (e.g., county, district).

        :return: The region_subdivision2 of this InvoiceAddress.
        :rtype: str
        """
        return self._region_subdivision2

    @region_subdivision2.setter
    def region_subdivision2(self, region_subdivision2: str) -> None:
        """
        Sets the region_subdivision2 of this InvoiceAddress.
        A secondary subdivision within the primary region subdivision (e.g., county, district).

        :param region_subdivision2: The region_subdivision2 of this InvoiceAddress.
        :type: str
        """
        

        self._region_subdivision2 = region_subdivision2

    @property
    def country(self) -> str:
        """
        Gets the country of this InvoiceAddress.
        Stores the name of the country in which the address is situated.

        :return: The country of this InvoiceAddress.
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country: str) -> None:
        """
        Sets the country of this InvoiceAddress.
        Stores the name of the country in which the address is situated.

        :param country: The country of this InvoiceAddress.
        :type: str
        """
        

        self._country = country

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

