# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class IpAddressRange(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        IpAddressRange - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'cidr': 'str',
            'service': 'str',
            'region': 'str',
            'direction': 'str'
        }

        self.attribute_map = {
            'cidr': 'cidr',
            'service': 'service',
            'region': 'region',
            'direction': 'direction'
        }

        self._cidr = None
        self._service = None
        self._region = None
        self._direction = None

    @property
    def cidr(self) -> str:
        """
        Gets the cidr of this IpAddressRange.


        :return: The cidr of this IpAddressRange.
        :rtype: str
        """
        return self._cidr

    @cidr.setter
    def cidr(self, cidr: str) -> None:
        """
        Sets the cidr of this IpAddressRange.


        :param cidr: The cidr of this IpAddressRange.
        :type: str
        """
        

        self._cidr = cidr

    @property
    def service(self) -> str:
        """
        Gets the service of this IpAddressRange.


        :return: The service of this IpAddressRange.
        :rtype: str
        """
        return self._service

    @service.setter
    def service(self, service: str) -> None:
        """
        Sets the service of this IpAddressRange.


        :param service: The service of this IpAddressRange.
        :type: str
        """
        if isinstance(service, int):
            service = str(service)
        allowed_values = ["api", "data-actions", "smtp", "imap", "graphapi", "audiohook", "open-messaging", "tts-connector", "audio-connector", "byot-stt", "bot-connector"]
        if service.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for service -> " + service)
            self._service = "outdated_sdk_version"
        else:
            self._service = service

    @property
    def region(self) -> str:
        """
        Gets the region of this IpAddressRange.


        :return: The region of this IpAddressRange.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region: str) -> None:
        """
        Sets the region of this IpAddressRange.


        :param region: The region of this IpAddressRange.
        :type: str
        """
        

        self._region = region

    @property
    def direction(self) -> str:
        """
        Gets the direction of this IpAddressRange.
        The direction of traffic for the IP range from the perspective of Genesys Cloud (e.g. inbound to Genesys; outbound from Genesys)

        :return: The direction of this IpAddressRange.
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction: str) -> None:
        """
        Sets the direction of this IpAddressRange.
        The direction of traffic for the IP range from the perspective of Genesys Cloud (e.g. inbound to Genesys; outbound from Genesys)

        :param direction: The direction of this IpAddressRange.
        :type: str
        """
        if isinstance(direction, int):
            direction = str(direction)
        allowed_values = ["inbound", "outbound", "both"]
        if direction.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for direction -> " + direction)
            self._direction = "outdated_sdk_version"
        else:
            self._direction = direction

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

