# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import JourneyAppEventsNotificationApp
    from . import JourneyAppEventsNotificationCustomEventAttribute
    from . import JourneyAppEventsNotificationDevice
    from . import JourneyAppEventsNotificationGeoLocation
    from . import JourneyAppEventsNotificationMktCampaign
    from . import JourneyAppEventsNotificationNetworkConnectivity
    from . import JourneyAppEventsNotificationSdkLibrary

class JourneyAppEventsNotificationAppMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        JourneyAppEventsNotificationAppMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'event_name': 'str',
            'screen_name': 'str',
            'app': 'JourneyAppEventsNotificationApp',
            'device': 'JourneyAppEventsNotificationDevice',
            'ip_address': 'str',
            'ip_organization': 'str',
            'geolocation': 'JourneyAppEventsNotificationGeoLocation',
            'sdk_library': 'JourneyAppEventsNotificationSdkLibrary',
            'network_connectivity': 'JourneyAppEventsNotificationNetworkConnectivity',
            'mkt_campaign': 'JourneyAppEventsNotificationMktCampaign',
            'search_query': 'str',
            'attributes': 'dict(str, JourneyAppEventsNotificationCustomEventAttribute)',
            'traits': 'dict(str, JourneyAppEventsNotificationCustomEventAttribute)'
        }

        self.attribute_map = {
            'event_name': 'eventName',
            'screen_name': 'screenName',
            'app': 'app',
            'device': 'device',
            'ip_address': 'ipAddress',
            'ip_organization': 'ipOrganization',
            'geolocation': 'geolocation',
            'sdk_library': 'sdkLibrary',
            'network_connectivity': 'networkConnectivity',
            'mkt_campaign': 'mktCampaign',
            'search_query': 'searchQuery',
            'attributes': 'attributes',
            'traits': 'traits'
        }

        self._event_name = None
        self._screen_name = None
        self._app = None
        self._device = None
        self._ip_address = None
        self._ip_organization = None
        self._geolocation = None
        self._sdk_library = None
        self._network_connectivity = None
        self._mkt_campaign = None
        self._search_query = None
        self._attributes = None
        self._traits = None

    @property
    def event_name(self) -> str:
        """
        Gets the event_name of this JourneyAppEventsNotificationAppMessage.


        :return: The event_name of this JourneyAppEventsNotificationAppMessage.
        :rtype: str
        """
        return self._event_name

    @event_name.setter
    def event_name(self, event_name: str) -> None:
        """
        Sets the event_name of this JourneyAppEventsNotificationAppMessage.


        :param event_name: The event_name of this JourneyAppEventsNotificationAppMessage.
        :type: str
        """
        

        self._event_name = event_name

    @property
    def screen_name(self) -> str:
        """
        Gets the screen_name of this JourneyAppEventsNotificationAppMessage.


        :return: The screen_name of this JourneyAppEventsNotificationAppMessage.
        :rtype: str
        """
        return self._screen_name

    @screen_name.setter
    def screen_name(self, screen_name: str) -> None:
        """
        Sets the screen_name of this JourneyAppEventsNotificationAppMessage.


        :param screen_name: The screen_name of this JourneyAppEventsNotificationAppMessage.
        :type: str
        """
        

        self._screen_name = screen_name

    @property
    def app(self) -> 'JourneyAppEventsNotificationApp':
        """
        Gets the app of this JourneyAppEventsNotificationAppMessage.


        :return: The app of this JourneyAppEventsNotificationAppMessage.
        :rtype: JourneyAppEventsNotificationApp
        """
        return self._app

    @app.setter
    def app(self, app: 'JourneyAppEventsNotificationApp') -> None:
        """
        Sets the app of this JourneyAppEventsNotificationAppMessage.


        :param app: The app of this JourneyAppEventsNotificationAppMessage.
        :type: JourneyAppEventsNotificationApp
        """
        

        self._app = app

    @property
    def device(self) -> 'JourneyAppEventsNotificationDevice':
        """
        Gets the device of this JourneyAppEventsNotificationAppMessage.


        :return: The device of this JourneyAppEventsNotificationAppMessage.
        :rtype: JourneyAppEventsNotificationDevice
        """
        return self._device

    @device.setter
    def device(self, device: 'JourneyAppEventsNotificationDevice') -> None:
        """
        Sets the device of this JourneyAppEventsNotificationAppMessage.


        :param device: The device of this JourneyAppEventsNotificationAppMessage.
        :type: JourneyAppEventsNotificationDevice
        """
        

        self._device = device

    @property
    def ip_address(self) -> str:
        """
        Gets the ip_address of this JourneyAppEventsNotificationAppMessage.


        :return: The ip_address of this JourneyAppEventsNotificationAppMessage.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address: str) -> None:
        """
        Sets the ip_address of this JourneyAppEventsNotificationAppMessage.


        :param ip_address: The ip_address of this JourneyAppEventsNotificationAppMessage.
        :type: str
        """
        

        self._ip_address = ip_address

    @property
    def ip_organization(self) -> str:
        """
        Gets the ip_organization of this JourneyAppEventsNotificationAppMessage.


        :return: The ip_organization of this JourneyAppEventsNotificationAppMessage.
        :rtype: str
        """
        return self._ip_organization

    @ip_organization.setter
    def ip_organization(self, ip_organization: str) -> None:
        """
        Sets the ip_organization of this JourneyAppEventsNotificationAppMessage.


        :param ip_organization: The ip_organization of this JourneyAppEventsNotificationAppMessage.
        :type: str
        """
        

        self._ip_organization = ip_organization

    @property
    def geolocation(self) -> 'JourneyAppEventsNotificationGeoLocation':
        """
        Gets the geolocation of this JourneyAppEventsNotificationAppMessage.


        :return: The geolocation of this JourneyAppEventsNotificationAppMessage.
        :rtype: JourneyAppEventsNotificationGeoLocation
        """
        return self._geolocation

    @geolocation.setter
    def geolocation(self, geolocation: 'JourneyAppEventsNotificationGeoLocation') -> None:
        """
        Sets the geolocation of this JourneyAppEventsNotificationAppMessage.


        :param geolocation: The geolocation of this JourneyAppEventsNotificationAppMessage.
        :type: JourneyAppEventsNotificationGeoLocation
        """
        

        self._geolocation = geolocation

    @property
    def sdk_library(self) -> 'JourneyAppEventsNotificationSdkLibrary':
        """
        Gets the sdk_library of this JourneyAppEventsNotificationAppMessage.


        :return: The sdk_library of this JourneyAppEventsNotificationAppMessage.
        :rtype: JourneyAppEventsNotificationSdkLibrary
        """
        return self._sdk_library

    @sdk_library.setter
    def sdk_library(self, sdk_library: 'JourneyAppEventsNotificationSdkLibrary') -> None:
        """
        Sets the sdk_library of this JourneyAppEventsNotificationAppMessage.


        :param sdk_library: The sdk_library of this JourneyAppEventsNotificationAppMessage.
        :type: JourneyAppEventsNotificationSdkLibrary
        """
        

        self._sdk_library = sdk_library

    @property
    def network_connectivity(self) -> 'JourneyAppEventsNotificationNetworkConnectivity':
        """
        Gets the network_connectivity of this JourneyAppEventsNotificationAppMessage.


        :return: The network_connectivity of this JourneyAppEventsNotificationAppMessage.
        :rtype: JourneyAppEventsNotificationNetworkConnectivity
        """
        return self._network_connectivity

    @network_connectivity.setter
    def network_connectivity(self, network_connectivity: 'JourneyAppEventsNotificationNetworkConnectivity') -> None:
        """
        Sets the network_connectivity of this JourneyAppEventsNotificationAppMessage.


        :param network_connectivity: The network_connectivity of this JourneyAppEventsNotificationAppMessage.
        :type: JourneyAppEventsNotificationNetworkConnectivity
        """
        

        self._network_connectivity = network_connectivity

    @property
    def mkt_campaign(self) -> 'JourneyAppEventsNotificationMktCampaign':
        """
        Gets the mkt_campaign of this JourneyAppEventsNotificationAppMessage.


        :return: The mkt_campaign of this JourneyAppEventsNotificationAppMessage.
        :rtype: JourneyAppEventsNotificationMktCampaign
        """
        return self._mkt_campaign

    @mkt_campaign.setter
    def mkt_campaign(self, mkt_campaign: 'JourneyAppEventsNotificationMktCampaign') -> None:
        """
        Sets the mkt_campaign of this JourneyAppEventsNotificationAppMessage.


        :param mkt_campaign: The mkt_campaign of this JourneyAppEventsNotificationAppMessage.
        :type: JourneyAppEventsNotificationMktCampaign
        """
        

        self._mkt_campaign = mkt_campaign

    @property
    def search_query(self) -> str:
        """
        Gets the search_query of this JourneyAppEventsNotificationAppMessage.


        :return: The search_query of this JourneyAppEventsNotificationAppMessage.
        :rtype: str
        """
        return self._search_query

    @search_query.setter
    def search_query(self, search_query: str) -> None:
        """
        Sets the search_query of this JourneyAppEventsNotificationAppMessage.


        :param search_query: The search_query of this JourneyAppEventsNotificationAppMessage.
        :type: str
        """
        

        self._search_query = search_query

    @property
    def attributes(self) -> Dict[str, 'JourneyAppEventsNotificationCustomEventAttribute']:
        """
        Gets the attributes of this JourneyAppEventsNotificationAppMessage.


        :return: The attributes of this JourneyAppEventsNotificationAppMessage.
        :rtype: dict(str, JourneyAppEventsNotificationCustomEventAttribute)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes: Dict[str, 'JourneyAppEventsNotificationCustomEventAttribute']) -> None:
        """
        Sets the attributes of this JourneyAppEventsNotificationAppMessage.


        :param attributes: The attributes of this JourneyAppEventsNotificationAppMessage.
        :type: dict(str, JourneyAppEventsNotificationCustomEventAttribute)
        """
        

        self._attributes = attributes

    @property
    def traits(self) -> Dict[str, 'JourneyAppEventsNotificationCustomEventAttribute']:
        """
        Gets the traits of this JourneyAppEventsNotificationAppMessage.


        :return: The traits of this JourneyAppEventsNotificationAppMessage.
        :rtype: dict(str, JourneyAppEventsNotificationCustomEventAttribute)
        """
        return self._traits

    @traits.setter
    def traits(self, traits: Dict[str, 'JourneyAppEventsNotificationCustomEventAttribute']) -> None:
        """
        Sets the traits of this JourneyAppEventsNotificationAppMessage.


        :param traits: The traits of this JourneyAppEventsNotificationAppMessage.
        :type: dict(str, JourneyAppEventsNotificationCustomEventAttribute)
        """
        

        self._traits = traits

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

