# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class JourneySessionEventsNotificationApp(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        JourneySessionEventsNotificationApp - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'namespace': 'str',
            'version': 'str',
            'build_number': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'namespace': 'namespace',
            'version': 'version',
            'build_number': 'buildNumber'
        }

        self._name = None
        self._namespace = None
        self._version = None
        self._build_number = None

    @property
    def name(self) -> str:
        """
        Gets the name of this JourneySessionEventsNotificationApp.


        :return: The name of this JourneySessionEventsNotificationApp.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this JourneySessionEventsNotificationApp.


        :param name: The name of this JourneySessionEventsNotificationApp.
        :type: str
        """
        

        self._name = name

    @property
    def namespace(self) -> str:
        """
        Gets the namespace of this JourneySessionEventsNotificationApp.


        :return: The namespace of this JourneySessionEventsNotificationApp.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace: str) -> None:
        """
        Sets the namespace of this JourneySessionEventsNotificationApp.


        :param namespace: The namespace of this JourneySessionEventsNotificationApp.
        :type: str
        """
        

        self._namespace = namespace

    @property
    def version(self) -> str:
        """
        Gets the version of this JourneySessionEventsNotificationApp.


        :return: The version of this JourneySessionEventsNotificationApp.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version: str) -> None:
        """
        Sets the version of this JourneySessionEventsNotificationApp.


        :param version: The version of this JourneySessionEventsNotificationApp.
        :type: str
        """
        

        self._version = version

    @property
    def build_number(self) -> str:
        """
        Gets the build_number of this JourneySessionEventsNotificationApp.


        :return: The build_number of this JourneySessionEventsNotificationApp.
        :rtype: str
        """
        return self._build_number

    @build_number.setter
    def build_number(self, build_number: str) -> None:
        """
        Sets the build_number of this JourneySessionEventsNotificationApp.


        :param build_number: The build_number of this JourneySessionEventsNotificationApp.
        :type: str
        """
        

        self._build_number = build_number

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

