# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import JourneyViewChart
    from . import JourneyViewElement
    from . import JourneyViewUser

class JourneyView(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        JourneyView - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'version': 'int',
            'created_by': 'JourneyViewUser',
            'modified_by': 'JourneyViewUser',
            'interval': 'str',
            'duration': 'str',
            'elements': 'list[JourneyViewElement]',
            'charts': 'list[JourneyViewChart]',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'version': 'version',
            'created_by': 'createdBy',
            'modified_by': 'modifiedBy',
            'interval': 'interval',
            'duration': 'duration',
            'elements': 'elements',
            'charts': 'charts',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._version = None
        self._created_by = None
        self._modified_by = None
        self._interval = None
        self._duration = None
        self._elements = None
        self._charts = None
        self._date_created = None
        self._date_modified = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this JourneyView.
        The globally unique identifier for the object.

        :return: The id of this JourneyView.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this JourneyView.
        The globally unique identifier for the object.

        :param id: The id of this JourneyView.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this JourneyView.


        :return: The name of this JourneyView.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this JourneyView.


        :param name: The name of this JourneyView.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this JourneyView.
        A description of the journey view

        :return: The description of this JourneyView.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this JourneyView.
        A description of the journey view

        :param description: The description of this JourneyView.
        :type: str
        """
        

        self._description = description

    @property
    def version(self) -> int:
        """
        Gets the version of this JourneyView.
        The version of the journey view

        :return: The version of this JourneyView.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this JourneyView.
        The version of the journey view

        :param version: The version of this JourneyView.
        :type: int
        """
        

        self._version = version

    @property
    def created_by(self) -> 'JourneyViewUser':
        """
        Gets the created_by of this JourneyView.
        User that has created the view.

        :return: The created_by of this JourneyView.
        :rtype: JourneyViewUser
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'JourneyViewUser') -> None:
        """
        Sets the created_by of this JourneyView.
        User that has created the view.

        :param created_by: The created_by of this JourneyView.
        :type: JourneyViewUser
        """
        

        self._created_by = created_by

    @property
    def modified_by(self) -> 'JourneyViewUser':
        """
        Gets the modified_by of this JourneyView.
        User that has modified the view.

        :return: The modified_by of this JourneyView.
        :rtype: JourneyViewUser
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by: 'JourneyViewUser') -> None:
        """
        Sets the modified_by of this JourneyView.
        User that has modified the view.

        :param modified_by: The modified_by of this JourneyView.
        :type: JourneyViewUser
        """
        

        self._modified_by = modified_by

    @property
    def interval(self) -> str:
        """
        Gets the interval of this JourneyView.
        An absolute timeframe for the journey view, expressed as an ISO 8601 interval. Only one of interval or duration must be specified. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :return: The interval of this JourneyView.
        :rtype: str
        """
        return self._interval

    @interval.setter
    def interval(self, interval: str) -> None:
        """
        Sets the interval of this JourneyView.
        An absolute timeframe for the journey view, expressed as an ISO 8601 interval. Only one of interval or duration must be specified. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :param interval: The interval of this JourneyView.
        :type: str
        """
        

        self._interval = interval

    @property
    def duration(self) -> str:
        """
        Gets the duration of this JourneyView.
        A relative timeframe for the journey view, expressed as an ISO 8601 duration. Only one of interval or duration must be specified. Periods are represented as an ISO-8601 string. For example: P1D or P1DT12H

        :return: The duration of this JourneyView.
        :rtype: str
        """
        return self._duration

    @duration.setter
    def duration(self, duration: str) -> None:
        """
        Sets the duration of this JourneyView.
        A relative timeframe for the journey view, expressed as an ISO 8601 duration. Only one of interval or duration must be specified. Periods are represented as an ISO-8601 string. For example: P1D or P1DT12H

        :param duration: The duration of this JourneyView.
        :type: str
        """
        

        self._duration = duration

    @property
    def elements(self) -> List['JourneyViewElement']:
        """
        Gets the elements of this JourneyView.
        The elements within the journey view

        :return: The elements of this JourneyView.
        :rtype: list[JourneyViewElement]
        """
        return self._elements

    @elements.setter
    def elements(self, elements: List['JourneyViewElement']) -> None:
        """
        Sets the elements of this JourneyView.
        The elements within the journey view

        :param elements: The elements of this JourneyView.
        :type: list[JourneyViewElement]
        """
        

        self._elements = elements

    @property
    def charts(self) -> List['JourneyViewChart']:
        """
        Gets the charts of this JourneyView.
        A list of charts to measure within context of the elements of the the journey view

        :return: The charts of this JourneyView.
        :rtype: list[JourneyViewChart]
        """
        return self._charts

    @charts.setter
    def charts(self, charts: List['JourneyViewChart']) -> None:
        """
        Sets the charts of this JourneyView.
        A list of charts to measure within context of the elements of the the journey view

        :param charts: The charts of this JourneyView.
        :type: list[JourneyViewChart]
        """
        

        self._charts = charts

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this JourneyView.
        The date when the journey view was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this JourneyView.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this JourneyView.
        The date when the journey view was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this JourneyView.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this JourneyView.
        The date when this version of the journey view was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this JourneyView.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this JourneyView.
        The date when this version of the journey view was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this JourneyView.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this JourneyView.
        The URI for this object

        :return: The self_uri of this JourneyView.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this JourneyView.
        The URI for this object

        :param self_uri: The self_uri of this JourneyView.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

