# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import JourneyViewElementAttributes
    from . import JourneyViewElementDisplayAttributes
    from . import JourneyViewElementFilter
    from . import JourneyViewLink

class JourneyViewElement(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        JourneyViewElement - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'attributes': 'JourneyViewElementAttributes',
            'display_attributes': 'JourneyViewElementDisplayAttributes',
            'filter': 'JourneyViewElementFilter',
            'followed_by': 'list[JourneyViewLink]'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'attributes': 'attributes',
            'display_attributes': 'displayAttributes',
            'filter': 'filter',
            'followed_by': 'followedBy'
        }

        self._id = None
        self._name = None
        self._attributes = None
        self._display_attributes = None
        self._filter = None
        self._followed_by = None

    @property
    def id(self) -> str:
        """
        Gets the id of this JourneyViewElement.
        The unique identifier of the element within the elements list

        :return: The id of this JourneyViewElement.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this JourneyViewElement.
        The unique identifier of the element within the elements list

        :param id: The id of this JourneyViewElement.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this JourneyViewElement.
        The unique name of the element within the view

        :return: The name of this JourneyViewElement.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this JourneyViewElement.
        The unique name of the element within the view

        :param name: The name of this JourneyViewElement.
        :type: str
        """
        

        self._name = name

    @property
    def attributes(self) -> 'JourneyViewElementAttributes':
        """
        Gets the attributes of this JourneyViewElement.
        Required attributes of the element

        :return: The attributes of this JourneyViewElement.
        :rtype: JourneyViewElementAttributes
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes: 'JourneyViewElementAttributes') -> None:
        """
        Sets the attributes of this JourneyViewElement.
        Required attributes of the element

        :param attributes: The attributes of this JourneyViewElement.
        :type: JourneyViewElementAttributes
        """
        

        self._attributes = attributes

    @property
    def display_attributes(self) -> 'JourneyViewElementDisplayAttributes':
        """
        Gets the display_attributes of this JourneyViewElement.
        Attributes that defines the visualization of the element in the journey view

        :return: The display_attributes of this JourneyViewElement.
        :rtype: JourneyViewElementDisplayAttributes
        """
        return self._display_attributes

    @display_attributes.setter
    def display_attributes(self, display_attributes: 'JourneyViewElementDisplayAttributes') -> None:
        """
        Sets the display_attributes of this JourneyViewElement.
        Attributes that defines the visualization of the element in the journey view

        :param display_attributes: The display_attributes of this JourneyViewElement.
        :type: JourneyViewElementDisplayAttributes
        """
        

        self._display_attributes = display_attributes

    @property
    def filter(self) -> 'JourneyViewElementFilter':
        """
        Gets the filter of this JourneyViewElement.
        Any filters applied to this element

        :return: The filter of this JourneyViewElement.
        :rtype: JourneyViewElementFilter
        """
        return self._filter

    @filter.setter
    def filter(self, filter: 'JourneyViewElementFilter') -> None:
        """
        Sets the filter of this JourneyViewElement.
        Any filters applied to this element

        :param filter: The filter of this JourneyViewElement.
        :type: JourneyViewElementFilter
        """
        

        self._filter = filter

    @property
    def followed_by(self) -> List['JourneyViewLink']:
        """
        Gets the followed_by of this JourneyViewElement.
        A list of JourneyViewLink objects, listing the elements downstream of this element

        :return: The followed_by of this JourneyViewElement.
        :rtype: list[JourneyViewLink]
        """
        return self._followed_by

    @followed_by.setter
    def followed_by(self, followed_by: List['JourneyViewLink']) -> None:
        """
        Sets the followed_by of this JourneyViewElement.
        A list of JourneyViewLink objects, listing the elements downstream of this element

        :param followed_by: The followed_by of this JourneyViewElement.
        :type: list[JourneyViewLink]
        """
        

        self._followed_by = followed_by

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

