# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import JourneyViewElementFilterRange

class JourneyViewElementFilterNumberPredicate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        JourneyViewElementFilterNumberPredicate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'dimension': 'str',
            'operator': 'str',
            'no_value': 'bool',
            'range': 'JourneyViewElementFilterRange'
        }

        self.attribute_map = {
            'dimension': 'dimension',
            'operator': 'operator',
            'no_value': 'noValue',
            'range': 'range'
        }

        self._dimension = None
        self._operator = None
        self._no_value = None
        self._range = None

    @property
    def dimension(self) -> str:
        """
        Gets the dimension of this JourneyViewElementFilterNumberPredicate.
        the element's attribute being filtered on

        :return: The dimension of this JourneyViewElementFilterNumberPredicate.
        :rtype: str
        """
        return self._dimension

    @dimension.setter
    def dimension(self, dimension: str) -> None:
        """
        Sets the dimension of this JourneyViewElementFilterNumberPredicate.
        the element's attribute being filtered on

        :param dimension: The dimension of this JourneyViewElementFilterNumberPredicate.
        :type: str
        """
        

        self._dimension = dimension

    @property
    def operator(self) -> str:
        """
        Gets the operator of this JourneyViewElementFilterNumberPredicate.
        Optional operator, default is Matches. Valid values: Matches

        :return: The operator of this JourneyViewElementFilterNumberPredicate.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator: str) -> None:
        """
        Sets the operator of this JourneyViewElementFilterNumberPredicate.
        Optional operator, default is Matches. Valid values: Matches

        :param operator: The operator of this JourneyViewElementFilterNumberPredicate.
        :type: str
        """
        if isinstance(operator, int):
            operator = str(operator)
        allowed_values = ["Matches", "NotMatches"]
        if operator.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for operator -> " + operator)
            self._operator = "outdated_sdk_version"
        else:
            self._operator = operator

    @property
    def no_value(self) -> bool:
        """
        Gets the no_value of this JourneyViewElementFilterNumberPredicate.
        set this to true if no specific value to be considered

        :return: The no_value of this JourneyViewElementFilterNumberPredicate.
        :rtype: bool
        """
        return self._no_value

    @no_value.setter
    def no_value(self, no_value: bool) -> None:
        """
        Sets the no_value of this JourneyViewElementFilterNumberPredicate.
        set this to true if no specific value to be considered

        :param no_value: The no_value of this JourneyViewElementFilterNumberPredicate.
        :type: bool
        """
        

        self._no_value = no_value

    @property
    def range(self) -> 'JourneyViewElementFilterRange':
        """
        Gets the range of this JourneyViewElementFilterNumberPredicate.
        the range of comparators to filter on

        :return: The range of this JourneyViewElementFilterNumberPredicate.
        :rtype: JourneyViewElementFilterRange
        """
        return self._range

    @range.setter
    def range(self, range: 'JourneyViewElementFilterRange') -> None:
        """
        Sets the range of this JourneyViewElementFilterNumberPredicate.
        the range of comparators to filter on

        :param range: The range of this JourneyViewElementFilterNumberPredicate.
        :type: JourneyViewElementFilterRange
        """
        

        self._range = range

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

