# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import JourneyView

class JourneyViewJob(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        JourneyViewJob - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'date_created': 'datetime',
            'date_completed': 'datetime',
            'status': 'str',
            'journey_view': 'JourneyView',
            'date_completion_estimated': 'datetime',
            'estimated_completion_margin': 'int',
            'user_id': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'date_created': 'dateCreated',
            'date_completed': 'dateCompleted',
            'status': 'status',
            'journey_view': 'journeyView',
            'date_completion_estimated': 'dateCompletionEstimated',
            'estimated_completion_margin': 'estimatedCompletionMargin',
            'user_id': 'userId',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._date_created = None
        self._date_completed = None
        self._status = None
        self._journey_view = None
        self._date_completion_estimated = None
        self._estimated_completion_margin = None
        self._user_id = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this JourneyViewJob.
        The globally unique identifier for the object.

        :return: The id of this JourneyViewJob.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this JourneyViewJob.
        The globally unique identifier for the object.

        :param id: The id of this JourneyViewJob.
        :type: str
        """
        

        self._id = id

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this JourneyViewJob.
        Timestamp of execution. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this JourneyViewJob.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this JourneyViewJob.
        Timestamp of execution. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this JourneyViewJob.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_completed(self) -> datetime:
        """
        Gets the date_completed of this JourneyViewJob.
        Timestamp of completion. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_completed of this JourneyViewJob.
        :rtype: datetime
        """
        return self._date_completed

    @date_completed.setter
    def date_completed(self, date_completed: datetime) -> None:
        """
        Sets the date_completed of this JourneyViewJob.
        Timestamp of completion. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_completed: The date_completed of this JourneyViewJob.
        :type: datetime
        """
        

        self._date_completed = date_completed

    @property
    def status(self) -> str:
        """
        Gets the status of this JourneyViewJob.
        The status of the job

        :return: The status of this JourneyViewJob.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this JourneyViewJob.
        The status of the job

        :param status: The status of this JourneyViewJob.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Accepted", "Executing", "Complete", "Failed", "Cancelled", "Scheduled"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def journey_view(self) -> 'JourneyView':
        """
        Gets the journey_view of this JourneyViewJob.
        The journey view for which the job is executed

        :return: The journey_view of this JourneyViewJob.
        :rtype: JourneyView
        """
        return self._journey_view

    @journey_view.setter
    def journey_view(self, journey_view: 'JourneyView') -> None:
        """
        Sets the journey_view of this JourneyViewJob.
        The journey view for which the job is executed

        :param journey_view: The journey_view of this JourneyViewJob.
        :type: JourneyView
        """
        

        self._journey_view = journey_view

    @property
    def date_completion_estimated(self) -> datetime:
        """
        Gets the date_completion_estimated of this JourneyViewJob.
        Timestamp for the estimated time of completion. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_completion_estimated of this JourneyViewJob.
        :rtype: datetime
        """
        return self._date_completion_estimated

    @date_completion_estimated.setter
    def date_completion_estimated(self, date_completion_estimated: datetime) -> None:
        """
        Sets the date_completion_estimated of this JourneyViewJob.
        Timestamp for the estimated time of completion. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_completion_estimated: The date_completion_estimated of this JourneyViewJob.
        :type: datetime
        """
        

        self._date_completion_estimated = date_completion_estimated

    @property
    def estimated_completion_margin(self) -> int:
        """
        Gets the estimated_completion_margin of this JourneyViewJob.
        Margin of error of the estimated time of completion

        :return: The estimated_completion_margin of this JourneyViewJob.
        :rtype: int
        """
        return self._estimated_completion_margin

    @estimated_completion_margin.setter
    def estimated_completion_margin(self, estimated_completion_margin: int) -> None:
        """
        Sets the estimated_completion_margin of this JourneyViewJob.
        Margin of error of the estimated time of completion

        :param estimated_completion_margin: The estimated_completion_margin of this JourneyViewJob.
        :type: int
        """
        

        self._estimated_completion_margin = estimated_completion_margin

    @property
    def user_id(self) -> str:
        """
        Gets the user_id of this JourneyViewJob.
        Id of the user who submitted the request

        :return: The user_id of this JourneyViewJob.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: str) -> None:
        """
        Sets the user_id of this JourneyViewJob.
        Id of the user who submitted the request

        :param user_id: The user_id of this JourneyViewJob.
        :type: str
        """
        

        self._user_id = user_id

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this JourneyViewJob.
        The URI for this object

        :return: The self_uri of this JourneyViewJob.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this JourneyViewJob.
        The URI for this object

        :param self_uri: The self_uri of this JourneyViewJob.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

