# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class JourneyViewResultMetrics(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        JourneyViewResultMetrics - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'participant_count': 'int',
            'active_count': 'int',
            'completed_count': 'int',
            'dropout_count': 'int',
            'flow_count': 'int'
        }

        self.attribute_map = {
            'participant_count': 'participantCount',
            'active_count': 'activeCount',
            'completed_count': 'completedCount',
            'dropout_count': 'dropoutCount',
            'flow_count': 'flowCount'
        }

        self._participant_count = None
        self._active_count = None
        self._completed_count = None
        self._dropout_count = None
        self._flow_count = None

    @property
    def participant_count(self) -> int:
        """
        Gets the participant_count of this JourneyViewResultMetrics.
        number of external contacts who participated at the element

        :return: The participant_count of this JourneyViewResultMetrics.
        :rtype: int
        """
        return self._participant_count

    @participant_count.setter
    def participant_count(self, participant_count: int) -> None:
        """
        Sets the participant_count of this JourneyViewResultMetrics.
        number of external contacts who participated at the element

        :param participant_count: The participant_count of this JourneyViewResultMetrics.
        :type: int
        """
        

        self._participant_count = participant_count

    @property
    def active_count(self) -> int:
        """
        Gets the active_count of this JourneyViewResultMetrics.
        number of external contacts who could still complete the journey

        :return: The active_count of this JourneyViewResultMetrics.
        :rtype: int
        """
        return self._active_count

    @active_count.setter
    def active_count(self, active_count: int) -> None:
        """
        Sets the active_count of this JourneyViewResultMetrics.
        number of external contacts who could still complete the journey

        :param active_count: The active_count of this JourneyViewResultMetrics.
        :type: int
        """
        

        self._active_count = active_count

    @property
    def completed_count(self) -> int:
        """
        Gets the completed_count of this JourneyViewResultMetrics.
        number of external contacts who completed the journey forward

        :return: The completed_count of this JourneyViewResultMetrics.
        :rtype: int
        """
        return self._completed_count

    @completed_count.setter
    def completed_count(self, completed_count: int) -> None:
        """
        Sets the completed_count of this JourneyViewResultMetrics.
        number of external contacts who completed the journey forward

        :param completed_count: The completed_count of this JourneyViewResultMetrics.
        :type: int
        """
        

        self._completed_count = completed_count

    @property
    def dropout_count(self) -> int:
        """
        Gets the dropout_count of this JourneyViewResultMetrics.
        number of external contacts who did not make it to the next element

        :return: The dropout_count of this JourneyViewResultMetrics.
        :rtype: int
        """
        return self._dropout_count

    @dropout_count.setter
    def dropout_count(self, dropout_count: int) -> None:
        """
        Sets the dropout_count of this JourneyViewResultMetrics.
        number of external contacts who did not make it to the next element

        :param dropout_count: The dropout_count of this JourneyViewResultMetrics.
        :type: int
        """
        

        self._dropout_count = dropout_count

    @property
    def flow_count(self) -> int:
        """
        Gets the flow_count of this JourneyViewResultMetrics.
        number of external contacts who moved from one element to next element but did not complete the journey

        :return: The flow_count of this JourneyViewResultMetrics.
        :rtype: int
        """
        return self._flow_count

    @flow_count.setter
    def flow_count(self, flow_count: int) -> None:
        """
        Sets the flow_count of this JourneyViewResultMetrics.
        number of external contacts who moved from one element to next element but did not complete the journey

        :param flow_count: The flow_count of this JourneyViewResultMetrics.
        :type: int
        """
        

        self._flow_count = flow_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

