# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import JourneyWebActionEventsNotificationActionMap
    from . import JourneyWebActionEventsNotificationActionTarget
    from . import JourneyWebActionEventsNotificationBrowser
    from . import JourneyWebActionEventsNotificationDevice
    from . import JourneyWebActionEventsNotificationEventAction
    from . import JourneyWebActionEventsNotificationGeoLocation
    from . import JourneyWebActionEventsNotificationMktCampaign
    from . import JourneyWebActionEventsNotificationReferrer

class JourneyWebActionEventsNotificationWebActionMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        JourneyWebActionEventsNotificationWebActionMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'action': 'JourneyWebActionEventsNotificationEventAction',
            'action_target': 'JourneyWebActionEventsNotificationActionTarget',
            'action_map': 'JourneyWebActionEventsNotificationActionMap',
            'error_code': 'str',
            'error_message': 'str',
            'user_agent_string': 'str',
            'ip_address': 'str',
            'ip_organization': 'str',
            'browser': 'JourneyWebActionEventsNotificationBrowser',
            'device': 'JourneyWebActionEventsNotificationDevice',
            'geolocation': 'JourneyWebActionEventsNotificationGeoLocation',
            'mkt_campaign': 'JourneyWebActionEventsNotificationMktCampaign',
            'visit_referrer': 'JourneyWebActionEventsNotificationReferrer',
            'time_to_disposition': 'int'
        }

        self.attribute_map = {
            'action': 'action',
            'action_target': 'actionTarget',
            'action_map': 'actionMap',
            'error_code': 'errorCode',
            'error_message': 'errorMessage',
            'user_agent_string': 'userAgentString',
            'ip_address': 'ipAddress',
            'ip_organization': 'ipOrganization',
            'browser': 'browser',
            'device': 'device',
            'geolocation': 'geolocation',
            'mkt_campaign': 'mktCampaign',
            'visit_referrer': 'visitReferrer',
            'time_to_disposition': 'timeToDisposition'
        }

        self._action = None
        self._action_target = None
        self._action_map = None
        self._error_code = None
        self._error_message = None
        self._user_agent_string = None
        self._ip_address = None
        self._ip_organization = None
        self._browser = None
        self._device = None
        self._geolocation = None
        self._mkt_campaign = None
        self._visit_referrer = None
        self._time_to_disposition = None

    @property
    def action(self) -> 'JourneyWebActionEventsNotificationEventAction':
        """
        Gets the action of this JourneyWebActionEventsNotificationWebActionMessage.


        :return: The action of this JourneyWebActionEventsNotificationWebActionMessage.
        :rtype: JourneyWebActionEventsNotificationEventAction
        """
        return self._action

    @action.setter
    def action(self, action: 'JourneyWebActionEventsNotificationEventAction') -> None:
        """
        Sets the action of this JourneyWebActionEventsNotificationWebActionMessage.


        :param action: The action of this JourneyWebActionEventsNotificationWebActionMessage.
        :type: JourneyWebActionEventsNotificationEventAction
        """
        

        self._action = action

    @property
    def action_target(self) -> 'JourneyWebActionEventsNotificationActionTarget':
        """
        Gets the action_target of this JourneyWebActionEventsNotificationWebActionMessage.


        :return: The action_target of this JourneyWebActionEventsNotificationWebActionMessage.
        :rtype: JourneyWebActionEventsNotificationActionTarget
        """
        return self._action_target

    @action_target.setter
    def action_target(self, action_target: 'JourneyWebActionEventsNotificationActionTarget') -> None:
        """
        Sets the action_target of this JourneyWebActionEventsNotificationWebActionMessage.


        :param action_target: The action_target of this JourneyWebActionEventsNotificationWebActionMessage.
        :type: JourneyWebActionEventsNotificationActionTarget
        """
        

        self._action_target = action_target

    @property
    def action_map(self) -> 'JourneyWebActionEventsNotificationActionMap':
        """
        Gets the action_map of this JourneyWebActionEventsNotificationWebActionMessage.


        :return: The action_map of this JourneyWebActionEventsNotificationWebActionMessage.
        :rtype: JourneyWebActionEventsNotificationActionMap
        """
        return self._action_map

    @action_map.setter
    def action_map(self, action_map: 'JourneyWebActionEventsNotificationActionMap') -> None:
        """
        Sets the action_map of this JourneyWebActionEventsNotificationWebActionMessage.


        :param action_map: The action_map of this JourneyWebActionEventsNotificationWebActionMessage.
        :type: JourneyWebActionEventsNotificationActionMap
        """
        

        self._action_map = action_map

    @property
    def error_code(self) -> str:
        """
        Gets the error_code of this JourneyWebActionEventsNotificationWebActionMessage.


        :return: The error_code of this JourneyWebActionEventsNotificationWebActionMessage.
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code: str) -> None:
        """
        Sets the error_code of this JourneyWebActionEventsNotificationWebActionMessage.


        :param error_code: The error_code of this JourneyWebActionEventsNotificationWebActionMessage.
        :type: str
        """
        

        self._error_code = error_code

    @property
    def error_message(self) -> str:
        """
        Gets the error_message of this JourneyWebActionEventsNotificationWebActionMessage.


        :return: The error_message of this JourneyWebActionEventsNotificationWebActionMessage.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message: str) -> None:
        """
        Sets the error_message of this JourneyWebActionEventsNotificationWebActionMessage.


        :param error_message: The error_message of this JourneyWebActionEventsNotificationWebActionMessage.
        :type: str
        """
        

        self._error_message = error_message

    @property
    def user_agent_string(self) -> str:
        """
        Gets the user_agent_string of this JourneyWebActionEventsNotificationWebActionMessage.


        :return: The user_agent_string of this JourneyWebActionEventsNotificationWebActionMessage.
        :rtype: str
        """
        return self._user_agent_string

    @user_agent_string.setter
    def user_agent_string(self, user_agent_string: str) -> None:
        """
        Sets the user_agent_string of this JourneyWebActionEventsNotificationWebActionMessage.


        :param user_agent_string: The user_agent_string of this JourneyWebActionEventsNotificationWebActionMessage.
        :type: str
        """
        

        self._user_agent_string = user_agent_string

    @property
    def ip_address(self) -> str:
        """
        Gets the ip_address of this JourneyWebActionEventsNotificationWebActionMessage.


        :return: The ip_address of this JourneyWebActionEventsNotificationWebActionMessage.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address: str) -> None:
        """
        Sets the ip_address of this JourneyWebActionEventsNotificationWebActionMessage.


        :param ip_address: The ip_address of this JourneyWebActionEventsNotificationWebActionMessage.
        :type: str
        """
        

        self._ip_address = ip_address

    @property
    def ip_organization(self) -> str:
        """
        Gets the ip_organization of this JourneyWebActionEventsNotificationWebActionMessage.


        :return: The ip_organization of this JourneyWebActionEventsNotificationWebActionMessage.
        :rtype: str
        """
        return self._ip_organization

    @ip_organization.setter
    def ip_organization(self, ip_organization: str) -> None:
        """
        Sets the ip_organization of this JourneyWebActionEventsNotificationWebActionMessage.


        :param ip_organization: The ip_organization of this JourneyWebActionEventsNotificationWebActionMessage.
        :type: str
        """
        

        self._ip_organization = ip_organization

    @property
    def browser(self) -> 'JourneyWebActionEventsNotificationBrowser':
        """
        Gets the browser of this JourneyWebActionEventsNotificationWebActionMessage.


        :return: The browser of this JourneyWebActionEventsNotificationWebActionMessage.
        :rtype: JourneyWebActionEventsNotificationBrowser
        """
        return self._browser

    @browser.setter
    def browser(self, browser: 'JourneyWebActionEventsNotificationBrowser') -> None:
        """
        Sets the browser of this JourneyWebActionEventsNotificationWebActionMessage.


        :param browser: The browser of this JourneyWebActionEventsNotificationWebActionMessage.
        :type: JourneyWebActionEventsNotificationBrowser
        """
        

        self._browser = browser

    @property
    def device(self) -> 'JourneyWebActionEventsNotificationDevice':
        """
        Gets the device of this JourneyWebActionEventsNotificationWebActionMessage.


        :return: The device of this JourneyWebActionEventsNotificationWebActionMessage.
        :rtype: JourneyWebActionEventsNotificationDevice
        """
        return self._device

    @device.setter
    def device(self, device: 'JourneyWebActionEventsNotificationDevice') -> None:
        """
        Sets the device of this JourneyWebActionEventsNotificationWebActionMessage.


        :param device: The device of this JourneyWebActionEventsNotificationWebActionMessage.
        :type: JourneyWebActionEventsNotificationDevice
        """
        

        self._device = device

    @property
    def geolocation(self) -> 'JourneyWebActionEventsNotificationGeoLocation':
        """
        Gets the geolocation of this JourneyWebActionEventsNotificationWebActionMessage.


        :return: The geolocation of this JourneyWebActionEventsNotificationWebActionMessage.
        :rtype: JourneyWebActionEventsNotificationGeoLocation
        """
        return self._geolocation

    @geolocation.setter
    def geolocation(self, geolocation: 'JourneyWebActionEventsNotificationGeoLocation') -> None:
        """
        Sets the geolocation of this JourneyWebActionEventsNotificationWebActionMessage.


        :param geolocation: The geolocation of this JourneyWebActionEventsNotificationWebActionMessage.
        :type: JourneyWebActionEventsNotificationGeoLocation
        """
        

        self._geolocation = geolocation

    @property
    def mkt_campaign(self) -> 'JourneyWebActionEventsNotificationMktCampaign':
        """
        Gets the mkt_campaign of this JourneyWebActionEventsNotificationWebActionMessage.


        :return: The mkt_campaign of this JourneyWebActionEventsNotificationWebActionMessage.
        :rtype: JourneyWebActionEventsNotificationMktCampaign
        """
        return self._mkt_campaign

    @mkt_campaign.setter
    def mkt_campaign(self, mkt_campaign: 'JourneyWebActionEventsNotificationMktCampaign') -> None:
        """
        Sets the mkt_campaign of this JourneyWebActionEventsNotificationWebActionMessage.


        :param mkt_campaign: The mkt_campaign of this JourneyWebActionEventsNotificationWebActionMessage.
        :type: JourneyWebActionEventsNotificationMktCampaign
        """
        

        self._mkt_campaign = mkt_campaign

    @property
    def visit_referrer(self) -> 'JourneyWebActionEventsNotificationReferrer':
        """
        Gets the visit_referrer of this JourneyWebActionEventsNotificationWebActionMessage.


        :return: The visit_referrer of this JourneyWebActionEventsNotificationWebActionMessage.
        :rtype: JourneyWebActionEventsNotificationReferrer
        """
        return self._visit_referrer

    @visit_referrer.setter
    def visit_referrer(self, visit_referrer: 'JourneyWebActionEventsNotificationReferrer') -> None:
        """
        Sets the visit_referrer of this JourneyWebActionEventsNotificationWebActionMessage.


        :param visit_referrer: The visit_referrer of this JourneyWebActionEventsNotificationWebActionMessage.
        :type: JourneyWebActionEventsNotificationReferrer
        """
        

        self._visit_referrer = visit_referrer

    @property
    def time_to_disposition(self) -> int:
        """
        Gets the time_to_disposition of this JourneyWebActionEventsNotificationWebActionMessage.


        :return: The time_to_disposition of this JourneyWebActionEventsNotificationWebActionMessage.
        :rtype: int
        """
        return self._time_to_disposition

    @time_to_disposition.setter
    def time_to_disposition(self, time_to_disposition: int) -> None:
        """
        Sets the time_to_disposition of this JourneyWebActionEventsNotificationWebActionMessage.


        :param time_to_disposition: The time_to_disposition of this JourneyWebActionEventsNotificationWebActionMessage.
        :type: int
        """
        

        self._time_to_disposition = time_to_disposition

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

