# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import Definition

class JsonSchemaWithDefinitions(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        JsonSchemaWithDefinitions - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'schema': 'str',
            'title': 'str',
            'description': 'str',
            'type': 'str',
            'required': 'list[str]',
            'properties': 'dict(str, object)',
            'additional_properties': 'object',
            'definitions': 'dict(str, Definition)'
        }

        self.attribute_map = {
            'id': 'id',
            'schema': '$schema',
            'title': 'title',
            'description': 'description',
            'type': 'type',
            'required': 'required',
            'properties': 'properties',
            'additional_properties': 'additionalProperties',
            'definitions': 'definitions'
        }

        self._id = None
        self._schema = None
        self._title = None
        self._description = None
        self._type = None
        self._required = None
        self._properties = None
        self._additional_properties = None
        self._definitions = None

    @property
    def id(self) -> str:
        """
        Gets the id of this JsonSchemaWithDefinitions.


        :return: The id of this JsonSchemaWithDefinitions.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this JsonSchemaWithDefinitions.


        :param id: The id of this JsonSchemaWithDefinitions.
        :type: str
        """
        

        self._id = id

    @property
    def schema(self) -> str:
        """
        Gets the schema of this JsonSchemaWithDefinitions.


        :return: The schema of this JsonSchemaWithDefinitions.
        :rtype: str
        """
        return self._schema

    @schema.setter
    def schema(self, schema: str) -> None:
        """
        Sets the schema of this JsonSchemaWithDefinitions.


        :param schema: The schema of this JsonSchemaWithDefinitions.
        :type: str
        """
        

        self._schema = schema

    @property
    def title(self) -> str:
        """
        Gets the title of this JsonSchemaWithDefinitions.


        :return: The title of this JsonSchemaWithDefinitions.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this JsonSchemaWithDefinitions.


        :param title: The title of this JsonSchemaWithDefinitions.
        :type: str
        """
        

        self._title = title

    @property
    def description(self) -> str:
        """
        Gets the description of this JsonSchemaWithDefinitions.


        :return: The description of this JsonSchemaWithDefinitions.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this JsonSchemaWithDefinitions.


        :param description: The description of this JsonSchemaWithDefinitions.
        :type: str
        """
        

        self._description = description

    @property
    def type(self) -> str:
        """
        Gets the type of this JsonSchemaWithDefinitions.


        :return: The type of this JsonSchemaWithDefinitions.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this JsonSchemaWithDefinitions.


        :param type: The type of this JsonSchemaWithDefinitions.
        :type: str
        """
        

        self._type = type

    @property
    def required(self) -> List[str]:
        """
        Gets the required of this JsonSchemaWithDefinitions.


        :return: The required of this JsonSchemaWithDefinitions.
        :rtype: list[str]
        """
        return self._required

    @required.setter
    def required(self, required: List[str]) -> None:
        """
        Sets the required of this JsonSchemaWithDefinitions.


        :param required: The required of this JsonSchemaWithDefinitions.
        :type: list[str]
        """
        

        self._required = required

    @property
    def properties(self) -> Dict[str, object]:
        """
        Gets the properties of this JsonSchemaWithDefinitions.


        :return: The properties of this JsonSchemaWithDefinitions.
        :rtype: dict(str, object)
        """
        return self._properties

    @properties.setter
    def properties(self, properties: Dict[str, object]) -> None:
        """
        Sets the properties of this JsonSchemaWithDefinitions.


        :param properties: The properties of this JsonSchemaWithDefinitions.
        :type: dict(str, object)
        """
        

        self._properties = properties

    @property
    def additional_properties(self) -> object:
        """
        Gets the additional_properties of this JsonSchemaWithDefinitions.


        :return: The additional_properties of this JsonSchemaWithDefinitions.
        :rtype: object
        """
        return self._additional_properties

    @additional_properties.setter
    def additional_properties(self, additional_properties: object) -> None:
        """
        Sets the additional_properties of this JsonSchemaWithDefinitions.


        :param additional_properties: The additional_properties of this JsonSchemaWithDefinitions.
        :type: object
        """
        

        self._additional_properties = additional_properties

    @property
    def definitions(self) -> Dict[str, 'Definition']:
        """
        Gets the definitions of this JsonSchemaWithDefinitions.


        :return: The definitions of this JsonSchemaWithDefinitions.
        :rtype: dict(str, Definition)
        """
        return self._definitions

    @definitions.setter
    def definitions(self, definitions: Dict[str, 'Definition']) -> None:
        """
        Sets the definitions of this JsonSchemaWithDefinitions.


        :param definitions: The definitions of this JsonSchemaWithDefinitions.
        :type: dict(str, Definition)
        """
        

        self._definitions = definitions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

