# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class KnowledgeConversationContext(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeConversationContext - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'conversation_id': 'str',
            'media_type': 'str',
            'message_type': 'str',
            'queue_id': 'str',
            'external_contact_id': 'str'
        }

        self.attribute_map = {
            'conversation_id': 'conversationId',
            'media_type': 'mediaType',
            'message_type': 'messageType',
            'queue_id': 'queueId',
            'external_contact_id': 'externalContactId'
        }

        self._conversation_id = None
        self._media_type = None
        self._message_type = None
        self._queue_id = None
        self._external_contact_id = None

    @property
    def conversation_id(self) -> str:
        """
        Gets the conversation_id of this KnowledgeConversationContext.
        The unique identifier of the conversation.

        :return: The conversation_id of this KnowledgeConversationContext.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id: str) -> None:
        """
        Sets the conversation_id of this KnowledgeConversationContext.
        The unique identifier of the conversation.

        :param conversation_id: The conversation_id of this KnowledgeConversationContext.
        :type: str
        """
        

        self._conversation_id = conversation_id

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this KnowledgeConversationContext.
        The media type of the conversation.

        :return: The media_type of this KnowledgeConversationContext.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this KnowledgeConversationContext.
        The media type of the conversation.

        :param media_type: The media_type of this KnowledgeConversationContext.
        :type: str
        """
        if isinstance(media_type, int):
            media_type = str(media_type)
        allowed_values = ["Unknown", "Callback", "Chat", "Cobrowse", "Email", "Message", "Screenshare", "Video", "Voice"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    @property
    def message_type(self) -> str:
        """
        Gets the message_type of this KnowledgeConversationContext.
        The message type of the conversation.

        :return: The message_type of this KnowledgeConversationContext.
        :rtype: str
        """
        return self._message_type

    @message_type.setter
    def message_type(self, message_type: str) -> None:
        """
        Sets the message_type of this KnowledgeConversationContext.
        The message type of the conversation.

        :param message_type: The message_type of this KnowledgeConversationContext.
        :type: str
        """
        if isinstance(message_type, int):
            message_type = str(message_type)
        allowed_values = ["Unknown", "Phone", "SMS", "GenesysChatWidget", "FacebookMessenger", "WeChat", "Whatsapp", "AppleBusinessChat", "Telegram", "Slack", "Signal", "Line", "Discord", "TwitterDirectMessage", "Other", "Open", "Instagram", "Apple"]
        if message_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for message_type -> " + message_type)
            self._message_type = "outdated_sdk_version"
        else:
            self._message_type = message_type

    @property
    def queue_id(self) -> str:
        """
        Gets the queue_id of this KnowledgeConversationContext.
        The unique identifier of the queue used to assign the interaction to the user.

        :return: The queue_id of this KnowledgeConversationContext.
        :rtype: str
        """
        return self._queue_id

    @queue_id.setter
    def queue_id(self, queue_id: str) -> None:
        """
        Sets the queue_id of this KnowledgeConversationContext.
        The unique identifier of the queue used to assign the interaction to the user.

        :param queue_id: The queue_id of this KnowledgeConversationContext.
        :type: str
        """
        

        self._queue_id = queue_id

    @property
    def external_contact_id(self) -> str:
        """
        Gets the external_contact_id of this KnowledgeConversationContext.
        The external contact identifier of the end-user participant.

        :return: The external_contact_id of this KnowledgeConversationContext.
        :rtype: str
        """
        return self._external_contact_id

    @external_contact_id.setter
    def external_contact_id(self, external_contact_id: str) -> None:
        """
        Sets the external_contact_id of this KnowledgeConversationContext.
        The external contact identifier of the end-user participant.

        :param external_contact_id: The external_contact_id of this KnowledgeConversationContext.
        :type: str
        """
        

        self._external_contact_id = external_contact_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

