# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef

class KnowledgeConversationContextResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeConversationContextResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'conversation': 'AddressableEntityRef',
            'queue': 'AddressableEntityRef',
            'external_contact': 'AddressableEntityRef',
            'media_type': 'str'
        }

        self.attribute_map = {
            'conversation': 'conversation',
            'queue': 'queue',
            'external_contact': 'externalContact',
            'media_type': 'mediaType'
        }

        self._conversation = None
        self._queue = None
        self._external_contact = None
        self._media_type = None

    @property
    def conversation(self) -> 'AddressableEntityRef':
        """
        Gets the conversation of this KnowledgeConversationContextResponse.
        The conversation.

        :return: The conversation of this KnowledgeConversationContextResponse.
        :rtype: AddressableEntityRef
        """
        return self._conversation

    @conversation.setter
    def conversation(self, conversation: 'AddressableEntityRef') -> None:
        """
        Sets the conversation of this KnowledgeConversationContextResponse.
        The conversation.

        :param conversation: The conversation of this KnowledgeConversationContextResponse.
        :type: AddressableEntityRef
        """
        

        self._conversation = conversation

    @property
    def queue(self) -> 'AddressableEntityRef':
        """
        Gets the queue of this KnowledgeConversationContextResponse.
        The queue used to assign the interaction to the user.

        :return: The queue of this KnowledgeConversationContextResponse.
        :rtype: AddressableEntityRef
        """
        return self._queue

    @queue.setter
    def queue(self, queue: 'AddressableEntityRef') -> None:
        """
        Sets the queue of this KnowledgeConversationContextResponse.
        The queue used to assign the interaction to the user.

        :param queue: The queue of this KnowledgeConversationContextResponse.
        :type: AddressableEntityRef
        """
        

        self._queue = queue

    @property
    def external_contact(self) -> 'AddressableEntityRef':
        """
        Gets the external_contact of this KnowledgeConversationContextResponse.
        The end-user participant of the conversation.

        :return: The external_contact of this KnowledgeConversationContextResponse.
        :rtype: AddressableEntityRef
        """
        return self._external_contact

    @external_contact.setter
    def external_contact(self, external_contact: 'AddressableEntityRef') -> None:
        """
        Sets the external_contact of this KnowledgeConversationContextResponse.
        The end-user participant of the conversation.

        :param external_contact: The external_contact of this KnowledgeConversationContextResponse.
        :type: AddressableEntityRef
        """
        

        self._external_contact = external_contact

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this KnowledgeConversationContextResponse.
        The media type of the conversation.

        :return: The media_type of this KnowledgeConversationContextResponse.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this KnowledgeConversationContextResponse.
        The media type of the conversation.

        :param media_type: The media_type of this KnowledgeConversationContextResponse.
        :type: str
        """
        if isinstance(media_type, int):
            media_type = str(media_type)
        allowed_values = ["Unknown", "Callback", "Chat", "Cobrowse", "Email", "Message", "Screenshare", "Video", "Voice"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

