# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DocumentQuery
    from . import KnowledgeConversationContext
    from . import KnowledgeSearchClientApplication

class KnowledgeDocumentChunkRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeDocumentChunkRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'query': 'str',
            'page_size': 'int',
            'page_number': 'int',
            'filter': 'DocumentQuery',
            'query_type': 'str',
            'preprocess_query': 'bool',
            'include_draft_documents': 'bool',
            'application': 'KnowledgeSearchClientApplication',
            'conversation_context': 'KnowledgeConversationContext',
            'confidence_threshold': 'float'
        }

        self.attribute_map = {
            'query': 'query',
            'page_size': 'pageSize',
            'page_number': 'pageNumber',
            'filter': 'filter',
            'query_type': 'queryType',
            'preprocess_query': 'preprocessQuery',
            'include_draft_documents': 'includeDraftDocuments',
            'application': 'application',
            'conversation_context': 'conversationContext',
            'confidence_threshold': 'confidenceThreshold'
        }

        self._query = None
        self._page_size = None
        self._page_number = None
        self._filter = None
        self._query_type = None
        self._preprocess_query = None
        self._include_draft_documents = None
        self._application = None
        self._conversation_context = None
        self._confidence_threshold = None

    @property
    def query(self) -> str:
        """
        Gets the query of this KnowledgeDocumentChunkRequest.
        Query to search chunks in the knowledge base.

        :return: The query of this KnowledgeDocumentChunkRequest.
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query: str) -> None:
        """
        Sets the query of this KnowledgeDocumentChunkRequest.
        Query to search chunks in the knowledge base.

        :param query: The query of this KnowledgeDocumentChunkRequest.
        :type: str
        """
        
        if len(query) > 2147483647:
            raise ValueError("Invalid value for `query`, length must be less than `2147483647`")

        if len(query) < 3:
            raise ValueError("Invalid value for `query`, length must be greater than or equal to `3`")


        self._query = query

    @property
    def page_size(self) -> int:
        """
        Gets the page_size of this KnowledgeDocumentChunkRequest.
        Page size of the returned results.

        :return: The page_size of this KnowledgeDocumentChunkRequest.
        :rtype: int
        """
        return self._page_size

    @page_size.setter
    def page_size(self, page_size: int) -> None:
        """
        Sets the page_size of this KnowledgeDocumentChunkRequest.
        Page size of the returned results.

        :param page_size: The page_size of this KnowledgeDocumentChunkRequest.
        :type: int
        """
        

        self._page_size = page_size

    @property
    def page_number(self) -> int:
        """
        Gets the page_number of this KnowledgeDocumentChunkRequest.
        Page number of the returned results.

        :return: The page_number of this KnowledgeDocumentChunkRequest.
        :rtype: int
        """
        return self._page_number

    @page_number.setter
    def page_number(self, page_number: int) -> None:
        """
        Sets the page_number of this KnowledgeDocumentChunkRequest.
        Page number of the returned results.

        :param page_number: The page_number of this KnowledgeDocumentChunkRequest.
        :type: int
        """
        

        self._page_number = page_number

    @property
    def filter(self) -> 'DocumentQuery':
        """
        Gets the filter of this KnowledgeDocumentChunkRequest.
        Filter for the document chunks.

        :return: The filter of this KnowledgeDocumentChunkRequest.
        :rtype: DocumentQuery
        """
        return self._filter

    @filter.setter
    def filter(self, filter: 'DocumentQuery') -> None:
        """
        Sets the filter of this KnowledgeDocumentChunkRequest.
        Filter for the document chunks.

        :param filter: The filter of this KnowledgeDocumentChunkRequest.
        :type: DocumentQuery
        """
        

        self._filter = filter

    @property
    def query_type(self) -> str:
        """
        Gets the query_type of this KnowledgeDocumentChunkRequest.
        The type of the query that initiates the chunks search.

        :return: The query_type of this KnowledgeDocumentChunkRequest.
        :rtype: str
        """
        return self._query_type

    @query_type.setter
    def query_type(self, query_type: str) -> None:
        """
        Sets the query_type of this KnowledgeDocumentChunkRequest.
        The type of the query that initiates the chunks search.

        :param query_type: The query_type of this KnowledgeDocumentChunkRequest.
        :type: str
        """
        if isinstance(query_type, int):
            query_type = str(query_type)
        allowed_values = ["AutoSearch", "ManualSearch", "Suggestion"]
        if query_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for query_type -> " + query_type)
            self._query_type = "outdated_sdk_version"
        else:
            self._query_type = query_type

    @property
    def preprocess_query(self) -> bool:
        """
        Gets the preprocess_query of this KnowledgeDocumentChunkRequest.
        Indicates whether the chunks search query should be preprocessed.

        :return: The preprocess_query of this KnowledgeDocumentChunkRequest.
        :rtype: bool
        """
        return self._preprocess_query

    @preprocess_query.setter
    def preprocess_query(self, preprocess_query: bool) -> None:
        """
        Sets the preprocess_query of this KnowledgeDocumentChunkRequest.
        Indicates whether the chunks search query should be preprocessed.

        :param preprocess_query: The preprocess_query of this KnowledgeDocumentChunkRequest.
        :type: bool
        """
        

        self._preprocess_query = preprocess_query

    @property
    def include_draft_documents(self) -> bool:
        """
        Gets the include_draft_documents of this KnowledgeDocumentChunkRequest.
        Indicates whether the chunk results would also include draft documents.

        :return: The include_draft_documents of this KnowledgeDocumentChunkRequest.
        :rtype: bool
        """
        return self._include_draft_documents

    @include_draft_documents.setter
    def include_draft_documents(self, include_draft_documents: bool) -> None:
        """
        Sets the include_draft_documents of this KnowledgeDocumentChunkRequest.
        Indicates whether the chunk results would also include draft documents.

        :param include_draft_documents: The include_draft_documents of this KnowledgeDocumentChunkRequest.
        :type: bool
        """
        

        self._include_draft_documents = include_draft_documents

    @property
    def application(self) -> 'KnowledgeSearchClientApplication':
        """
        Gets the application of this KnowledgeDocumentChunkRequest.
        The client application details from which chunks request was sent.

        :return: The application of this KnowledgeDocumentChunkRequest.
        :rtype: KnowledgeSearchClientApplication
        """
        return self._application

    @application.setter
    def application(self, application: 'KnowledgeSearchClientApplication') -> None:
        """
        Sets the application of this KnowledgeDocumentChunkRequest.
        The client application details from which chunks request was sent.

        :param application: The application of this KnowledgeDocumentChunkRequest.
        :type: KnowledgeSearchClientApplication
        """
        

        self._application = application

    @property
    def conversation_context(self) -> 'KnowledgeConversationContext':
        """
        Gets the conversation_context of this KnowledgeDocumentChunkRequest.
        Conversation context information if the chunks search is initiated in the context of a conversation.

        :return: The conversation_context of this KnowledgeDocumentChunkRequest.
        :rtype: KnowledgeConversationContext
        """
        return self._conversation_context

    @conversation_context.setter
    def conversation_context(self, conversation_context: 'KnowledgeConversationContext') -> None:
        """
        Sets the conversation_context of this KnowledgeDocumentChunkRequest.
        Conversation context information if the chunks search is initiated in the context of a conversation.

        :param conversation_context: The conversation_context of this KnowledgeDocumentChunkRequest.
        :type: KnowledgeConversationContext
        """
        

        self._conversation_context = conversation_context

    @property
    def confidence_threshold(self) -> float:
        """
        Gets the confidence_threshold of this KnowledgeDocumentChunkRequest.
        The confidence threshold for the chunk results. If applied, the returned results will have an equal or higher confidence than the threshold. The value should be between 0 to 1.

        :return: The confidence_threshold of this KnowledgeDocumentChunkRequest.
        :rtype: float
        """
        return self._confidence_threshold

    @confidence_threshold.setter
    def confidence_threshold(self, confidence_threshold: float) -> None:
        """
        Sets the confidence_threshold of this KnowledgeDocumentChunkRequest.
        The confidence threshold for the chunk results. If applied, the returned results will have an equal or higher confidence than the threshold. The value should be between 0 to 1.

        :param confidence_threshold: The confidence_threshold of this KnowledgeDocumentChunkRequest.
        :type: float
        """
        

        self._confidence_threshold = confidence_threshold

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

