# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DocumentChunkBlock
    from . import KnowledgeConversationContextResponse
    from . import KnowledgeSearchClientApplication

class KnowledgeDocumentChunkResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeDocumentChunkResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'query': 'str',
            'total': 'int',
            'page_count': 'int',
            'page_size': 'int',
            'page_number': 'int',
            'query_type': 'str',
            'search_id': 'str',
            'preprocess_query': 'bool',
            'confidence_threshold': 'float',
            'results': 'list[DocumentChunkBlock]',
            'application': 'KnowledgeSearchClientApplication',
            'conversation_context': 'KnowledgeConversationContextResponse'
        }

        self.attribute_map = {
            'query': 'query',
            'total': 'total',
            'page_count': 'pageCount',
            'page_size': 'pageSize',
            'page_number': 'pageNumber',
            'query_type': 'queryType',
            'search_id': 'searchId',
            'preprocess_query': 'preprocessQuery',
            'confidence_threshold': 'confidenceThreshold',
            'results': 'results',
            'application': 'application',
            'conversation_context': 'conversationContext'
        }

        self._query = None
        self._total = None
        self._page_count = None
        self._page_size = None
        self._page_number = None
        self._query_type = None
        self._search_id = None
        self._preprocess_query = None
        self._confidence_threshold = None
        self._results = None
        self._application = None
        self._conversation_context = None

    @property
    def query(self) -> str:
        """
        Gets the query of this KnowledgeDocumentChunkResponse.
        Query to search chunks in the knowledge base.

        :return: The query of this KnowledgeDocumentChunkResponse.
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query: str) -> None:
        """
        Sets the query of this KnowledgeDocumentChunkResponse.
        Query to search chunks in the knowledge base.

        :param query: The query of this KnowledgeDocumentChunkResponse.
        :type: str
        """
        

        self._query = query

    @property
    def total(self) -> int:
        """
        Gets the total of this KnowledgeDocumentChunkResponse.
        The total number of chunks matching the query.

        :return: The total of this KnowledgeDocumentChunkResponse.
        :rtype: int
        """
        return self._total

    @total.setter
    def total(self, total: int) -> None:
        """
        Sets the total of this KnowledgeDocumentChunkResponse.
        The total number of chunks matching the query.

        :param total: The total of this KnowledgeDocumentChunkResponse.
        :type: int
        """
        

        self._total = total

    @property
    def page_count(self) -> int:
        """
        Gets the page_count of this KnowledgeDocumentChunkResponse.
        Number of pages returned in the result calculated according to the pageSize and the total

        :return: The page_count of this KnowledgeDocumentChunkResponse.
        :rtype: int
        """
        return self._page_count

    @page_count.setter
    def page_count(self, page_count: int) -> None:
        """
        Sets the page_count of this KnowledgeDocumentChunkResponse.
        Number of pages returned in the result calculated according to the pageSize and the total

        :param page_count: The page_count of this KnowledgeDocumentChunkResponse.
        :type: int
        """
        

        self._page_count = page_count

    @property
    def page_size(self) -> int:
        """
        Gets the page_size of this KnowledgeDocumentChunkResponse.
        Page size of the returned results.

        :return: The page_size of this KnowledgeDocumentChunkResponse.
        :rtype: int
        """
        return self._page_size

    @page_size.setter
    def page_size(self, page_size: int) -> None:
        """
        Sets the page_size of this KnowledgeDocumentChunkResponse.
        Page size of the returned results.

        :param page_size: The page_size of this KnowledgeDocumentChunkResponse.
        :type: int
        """
        

        self._page_size = page_size

    @property
    def page_number(self) -> int:
        """
        Gets the page_number of this KnowledgeDocumentChunkResponse.
        Page number of the returned results.

        :return: The page_number of this KnowledgeDocumentChunkResponse.
        :rtype: int
        """
        return self._page_number

    @page_number.setter
    def page_number(self, page_number: int) -> None:
        """
        Sets the page_number of this KnowledgeDocumentChunkResponse.
        Page number of the returned results.

        :param page_number: The page_number of this KnowledgeDocumentChunkResponse.
        :type: int
        """
        

        self._page_number = page_number

    @property
    def query_type(self) -> str:
        """
        Gets the query_type of this KnowledgeDocumentChunkResponse.
        The type of the query that initiates the chunks search.

        :return: The query_type of this KnowledgeDocumentChunkResponse.
        :rtype: str
        """
        return self._query_type

    @query_type.setter
    def query_type(self, query_type: str) -> None:
        """
        Sets the query_type of this KnowledgeDocumentChunkResponse.
        The type of the query that initiates the chunks search.

        :param query_type: The query_type of this KnowledgeDocumentChunkResponse.
        :type: str
        """
        if isinstance(query_type, int):
            query_type = str(query_type)
        allowed_values = ["AutoSearch", "ManualSearch", "Suggestion"]
        if query_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for query_type -> " + query_type)
            self._query_type = "outdated_sdk_version"
        else:
            self._query_type = query_type

    @property
    def search_id(self) -> str:
        """
        Gets the search_id of this KnowledgeDocumentChunkResponse.
        The globally unique identifier for the chunks search.

        :return: The search_id of this KnowledgeDocumentChunkResponse.
        :rtype: str
        """
        return self._search_id

    @search_id.setter
    def search_id(self, search_id: str) -> None:
        """
        Sets the search_id of this KnowledgeDocumentChunkResponse.
        The globally unique identifier for the chunks search.

        :param search_id: The search_id of this KnowledgeDocumentChunkResponse.
        :type: str
        """
        

        self._search_id = search_id

    @property
    def preprocess_query(self) -> bool:
        """
        Gets the preprocess_query of this KnowledgeDocumentChunkResponse.
        Indicates whether the chunks search query should be preprocessed.

        :return: The preprocess_query of this KnowledgeDocumentChunkResponse.
        :rtype: bool
        """
        return self._preprocess_query

    @preprocess_query.setter
    def preprocess_query(self, preprocess_query: bool) -> None:
        """
        Sets the preprocess_query of this KnowledgeDocumentChunkResponse.
        Indicates whether the chunks search query should be preprocessed.

        :param preprocess_query: The preprocess_query of this KnowledgeDocumentChunkResponse.
        :type: bool
        """
        

        self._preprocess_query = preprocess_query

    @property
    def confidence_threshold(self) -> float:
        """
        Gets the confidence_threshold of this KnowledgeDocumentChunkResponse.
        The confidence threshold for the chunk results. If applied, the returned results will have an equal or higher chunk confidence than the threshold.

        :return: The confidence_threshold of this KnowledgeDocumentChunkResponse.
        :rtype: float
        """
        return self._confidence_threshold

    @confidence_threshold.setter
    def confidence_threshold(self, confidence_threshold: float) -> None:
        """
        Sets the confidence_threshold of this KnowledgeDocumentChunkResponse.
        The confidence threshold for the chunk results. If applied, the returned results will have an equal or higher chunk confidence than the threshold.

        :param confidence_threshold: The confidence_threshold of this KnowledgeDocumentChunkResponse.
        :type: float
        """
        

        self._confidence_threshold = confidence_threshold

    @property
    def results(self) -> List['DocumentChunkBlock']:
        """
        Gets the results of this KnowledgeDocumentChunkResponse.
        Chunks matching the search query.

        :return: The results of this KnowledgeDocumentChunkResponse.
        :rtype: list[DocumentChunkBlock]
        """
        return self._results

    @results.setter
    def results(self, results: List['DocumentChunkBlock']) -> None:
        """
        Sets the results of this KnowledgeDocumentChunkResponse.
        Chunks matching the search query.

        :param results: The results of this KnowledgeDocumentChunkResponse.
        :type: list[DocumentChunkBlock]
        """
        

        self._results = results

    @property
    def application(self) -> 'KnowledgeSearchClientApplication':
        """
        Gets the application of this KnowledgeDocumentChunkResponse.
        The client application details from which chunks search happened.

        :return: The application of this KnowledgeDocumentChunkResponse.
        :rtype: KnowledgeSearchClientApplication
        """
        return self._application

    @application.setter
    def application(self, application: 'KnowledgeSearchClientApplication') -> None:
        """
        Sets the application of this KnowledgeDocumentChunkResponse.
        The client application details from which chunks search happened.

        :param application: The application of this KnowledgeDocumentChunkResponse.
        :type: KnowledgeSearchClientApplication
        """
        

        self._application = application

    @property
    def conversation_context(self) -> 'KnowledgeConversationContextResponse':
        """
        Gets the conversation_context of this KnowledgeDocumentChunkResponse.
        Conversation context information if the chunks search is initiated in the context of a conversation.

        :return: The conversation_context of this KnowledgeDocumentChunkResponse.
        :rtype: KnowledgeConversationContextResponse
        """
        return self._conversation_context

    @conversation_context.setter
    def conversation_context(self, conversation_context: 'KnowledgeConversationContextResponse') -> None:
        """
        Sets the conversation_context of this KnowledgeDocumentChunkResponse.
        Conversation context information if the chunks search is initiated in the context of a conversation.

        :param conversation_context: The conversation_context of this KnowledgeDocumentChunkResponse.
        :type: KnowledgeConversationContextResponse
        """
        

        self._conversation_context = conversation_context

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

