# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef

class KnowledgeDocumentContentUpload(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeDocumentContentUpload - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'content_type': 'str',
            'file_name': 'str',
            'status': 'str',
            'upload_key': 'str',
            'url': 'str',
            'headers': 'dict(str, str)',
            'document': 'AddressableEntityRef',
            'error_message': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'content_type': 'contentType',
            'file_name': 'fileName',
            'status': 'status',
            'upload_key': 'uploadKey',
            'url': 'url',
            'headers': 'headers',
            'document': 'document',
            'error_message': 'errorMessage',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._content_type = None
        self._file_name = None
        self._status = None
        self._upload_key = None
        self._url = None
        self._headers = None
        self._document = None
        self._error_message = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this KnowledgeDocumentContentUpload.
        The globally unique identifier for the object.

        :return: The id of this KnowledgeDocumentContentUpload.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this KnowledgeDocumentContentUpload.
        The globally unique identifier for the object.

        :param id: The id of this KnowledgeDocumentContentUpload.
        :type: str
        """
        

        self._id = id

    @property
    def content_type(self) -> str:
        """
        Gets the content_type of this KnowledgeDocumentContentUpload.
        Type of Article Content.

        :return: The content_type of this KnowledgeDocumentContentUpload.
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type: str) -> None:
        """
        Sets the content_type of this KnowledgeDocumentContentUpload.
        Type of Article Content.

        :param content_type: The content_type of this KnowledgeDocumentContentUpload.
        :type: str
        """
        if isinstance(content_type, int):
            content_type = str(content_type)
        allowed_values = ["Body", "Attachment"]
        if content_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for content_type -> " + content_type)
            self._content_type = "outdated_sdk_version"
        else:
            self._content_type = content_type

    @property
    def file_name(self) -> str:
        """
        Gets the file_name of this KnowledgeDocumentContentUpload.
        Name of the file to upload. It must not start with a dot and not end with a forward slash. Whitespace and the following characters are not allowed: \\{^}%`]\">[~<#|

        :return: The file_name of this KnowledgeDocumentContentUpload.
        :rtype: str
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name: str) -> None:
        """
        Sets the file_name of this KnowledgeDocumentContentUpload.
        Name of the file to upload. It must not start with a dot and not end with a forward slash. Whitespace and the following characters are not allowed: \\{^}%`]\">[~<#|

        :param file_name: The file_name of this KnowledgeDocumentContentUpload.
        :type: str
        """
        

        self._file_name = file_name

    @property
    def status(self) -> str:
        """
        Gets the status of this KnowledgeDocumentContentUpload.
        Status of the upload operation

        :return: The status of this KnowledgeDocumentContentUpload.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this KnowledgeDocumentContentUpload.
        Status of the upload operation

        :param status: The status of this KnowledgeDocumentContentUpload.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["ValidationFailed", "InProgress", "Completed"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def upload_key(self) -> str:
        """
        Gets the upload_key of this KnowledgeDocumentContentUpload.
        Key that identifies the file in the storage including the file name

        :return: The upload_key of this KnowledgeDocumentContentUpload.
        :rtype: str
        """
        return self._upload_key

    @upload_key.setter
    def upload_key(self, upload_key: str) -> None:
        """
        Sets the upload_key of this KnowledgeDocumentContentUpload.
        Key that identifies the file in the storage including the file name

        :param upload_key: The upload_key of this KnowledgeDocumentContentUpload.
        :type: str
        """
        

        self._upload_key = upload_key

    @property
    def url(self) -> str:
        """
        Gets the url of this KnowledgeDocumentContentUpload.
        Presigned URL to PUT the file to

        :return: The url of this KnowledgeDocumentContentUpload.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url: str) -> None:
        """
        Sets the url of this KnowledgeDocumentContentUpload.
        Presigned URL to PUT the file to

        :param url: The url of this KnowledgeDocumentContentUpload.
        :type: str
        """
        

        self._url = url

    @property
    def headers(self) -> Dict[str, str]:
        """
        Gets the headers of this KnowledgeDocumentContentUpload.
        Required headers when uploading a file through PUT request to the URL

        :return: The headers of this KnowledgeDocumentContentUpload.
        :rtype: dict(str, str)
        """
        return self._headers

    @headers.setter
    def headers(self, headers: Dict[str, str]) -> None:
        """
        Sets the headers of this KnowledgeDocumentContentUpload.
        Required headers when uploading a file through PUT request to the URL

        :param headers: The headers of this KnowledgeDocumentContentUpload.
        :type: dict(str, str)
        """
        

        self._headers = headers

    @property
    def document(self) -> 'AddressableEntityRef':
        """
        Gets the document of this KnowledgeDocumentContentUpload.
        ID of the document for which article content is to be uploaded

        :return: The document of this KnowledgeDocumentContentUpload.
        :rtype: AddressableEntityRef
        """
        return self._document

    @document.setter
    def document(self, document: 'AddressableEntityRef') -> None:
        """
        Sets the document of this KnowledgeDocumentContentUpload.
        ID of the document for which article content is to be uploaded

        :param document: The document of this KnowledgeDocumentContentUpload.
        :type: AddressableEntityRef
        """
        

        self._document = document

    @property
    def error_message(self) -> str:
        """
        Gets the error_message of this KnowledgeDocumentContentUpload.
        Error message when upload fails

        :return: The error_message of this KnowledgeDocumentContentUpload.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message: str) -> None:
        """
        Sets the error_message of this KnowledgeDocumentContentUpload.
        Error message when upload fails

        :param error_message: The error_message of this KnowledgeDocumentContentUpload.
        :type: str
        """
        

        self._error_message = error_message

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this KnowledgeDocumentContentUpload.
        The URI for this object

        :return: The self_uri of this KnowledgeDocumentContentUpload.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this KnowledgeDocumentContentUpload.
        The URI for this object

        :param self_uri: The self_uri of this KnowledgeDocumentContentUpload.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

