# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import KnowledgeDocumentResponse

class KnowledgeDocumentVersion(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeDocumentVersion - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'date_published': 'datetime',
            'document': 'KnowledgeDocumentResponse',
            'restore_from_version_id': 'str',
            'version_number': 'int',
            'date_expires': 'datetime',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'date_published': 'datePublished',
            'document': 'document',
            'restore_from_version_id': 'restoreFromVersionId',
            'version_number': 'versionNumber',
            'date_expires': 'dateExpires',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._date_published = None
        self._document = None
        self._restore_from_version_id = None
        self._version_number = None
        self._date_expires = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this KnowledgeDocumentVersion.
        Globally unique identifier for the document version.

        :return: The id of this KnowledgeDocumentVersion.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this KnowledgeDocumentVersion.
        Globally unique identifier for the document version.

        :param id: The id of this KnowledgeDocumentVersion.
        :type: str
        """
        

        self._id = id

    @property
    def date_published(self) -> datetime:
        """
        Gets the date_published of this KnowledgeDocumentVersion.
        Published date of document version. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_published of this KnowledgeDocumentVersion.
        :rtype: datetime
        """
        return self._date_published

    @date_published.setter
    def date_published(self, date_published: datetime) -> None:
        """
        Sets the date_published of this KnowledgeDocumentVersion.
        Published date of document version. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_published: The date_published of this KnowledgeDocumentVersion.
        :type: datetime
        """
        

        self._date_published = date_published

    @property
    def document(self) -> 'KnowledgeDocumentResponse':
        """
        Gets the document of this KnowledgeDocumentVersion.
        The document which is versioned.

        :return: The document of this KnowledgeDocumentVersion.
        :rtype: KnowledgeDocumentResponse
        """
        return self._document

    @document.setter
    def document(self, document: 'KnowledgeDocumentResponse') -> None:
        """
        Sets the document of this KnowledgeDocumentVersion.
        The document which is versioned.

        :param document: The document of this KnowledgeDocumentVersion.
        :type: KnowledgeDocumentResponse
        """
        

        self._document = document

    @property
    def restore_from_version_id(self) -> str:
        """
        Gets the restore_from_version_id of this KnowledgeDocumentVersion.
        The globally unique identifier for the document version. If the value is provided, the document is restored to the given version. If not, it publishes the draft changes as a new version of the document.

        :return: The restore_from_version_id of this KnowledgeDocumentVersion.
        :rtype: str
        """
        return self._restore_from_version_id

    @restore_from_version_id.setter
    def restore_from_version_id(self, restore_from_version_id: str) -> None:
        """
        Sets the restore_from_version_id of this KnowledgeDocumentVersion.
        The globally unique identifier for the document version. If the value is provided, the document is restored to the given version. If not, it publishes the draft changes as a new version of the document.

        :param restore_from_version_id: The restore_from_version_id of this KnowledgeDocumentVersion.
        :type: str
        """
        

        self._restore_from_version_id = restore_from_version_id

    @property
    def version_number(self) -> int:
        """
        Gets the version_number of this KnowledgeDocumentVersion.
        Version Number of the document.

        :return: The version_number of this KnowledgeDocumentVersion.
        :rtype: int
        """
        return self._version_number

    @version_number.setter
    def version_number(self, version_number: int) -> None:
        """
        Sets the version_number of this KnowledgeDocumentVersion.
        Version Number of the document.

        :param version_number: The version_number of this KnowledgeDocumentVersion.
        :type: int
        """
        

        self._version_number = version_number

    @property
    def date_expires(self) -> datetime:
        """
        Gets the date_expires of this KnowledgeDocumentVersion.
        Expiry date of document version, applicable only to the 'Archived' version of the document. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_expires of this KnowledgeDocumentVersion.
        :rtype: datetime
        """
        return self._date_expires

    @date_expires.setter
    def date_expires(self, date_expires: datetime) -> None:
        """
        Sets the date_expires of this KnowledgeDocumentVersion.
        Expiry date of document version, applicable only to the 'Archived' version of the document. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_expires: The date_expires of this KnowledgeDocumentVersion.
        :type: datetime
        """
        

        self._date_expires = date_expires

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this KnowledgeDocumentVersion.
        The URI for this object

        :return: The self_uri of this KnowledgeDocumentVersion.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this KnowledgeDocumentVersion.
        The URI for this object

        :param self_uri: The self_uri of this KnowledgeDocumentVersion.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

