# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import KnowledgeExportJobFilter

class KnowledgeExportJobRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeExportJobRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'export_filter': 'KnowledgeExportJobFilter',
            'file_type': 'str',
            'source_id': 'str',
            'json_file_version': 'int'
        }

        self.attribute_map = {
            'export_filter': 'exportFilter',
            'file_type': 'fileType',
            'source_id': 'sourceId',
            'json_file_version': 'jsonFileVersion'
        }

        self._export_filter = None
        self._file_type = None
        self._source_id = None
        self._json_file_version = None

    @property
    def export_filter(self) -> 'KnowledgeExportJobFilter':
        """
        Gets the export_filter of this KnowledgeExportJobRequest.
        What to export.

        :return: The export_filter of this KnowledgeExportJobRequest.
        :rtype: KnowledgeExportJobFilter
        """
        return self._export_filter

    @export_filter.setter
    def export_filter(self, export_filter: 'KnowledgeExportJobFilter') -> None:
        """
        Sets the export_filter of this KnowledgeExportJobRequest.
        What to export.

        :param export_filter: The export_filter of this KnowledgeExportJobRequest.
        :type: KnowledgeExportJobFilter
        """
        

        self._export_filter = export_filter

    @property
    def file_type(self) -> str:
        """
        Gets the file_type of this KnowledgeExportJobRequest.
        File type of the document

        :return: The file_type of this KnowledgeExportJobRequest.
        :rtype: str
        """
        return self._file_type

    @file_type.setter
    def file_type(self, file_type: str) -> None:
        """
        Sets the file_type of this KnowledgeExportJobRequest.
        File type of the document

        :param file_type: The file_type of this KnowledgeExportJobRequest.
        :type: str
        """
        if isinstance(file_type, int):
            file_type = str(file_type)
        allowed_values = ["Json", "Csv", "Xlsx"]
        if file_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for file_type -> " + file_type)
            self._file_type = "outdated_sdk_version"
        else:
            self._file_type = file_type

    @property
    def source_id(self) -> str:
        """
        Gets the source_id of this KnowledgeExportJobRequest.
        Knowledge integration source id.

        :return: The source_id of this KnowledgeExportJobRequest.
        :rtype: str
        """
        return self._source_id

    @source_id.setter
    def source_id(self, source_id: str) -> None:
        """
        Sets the source_id of this KnowledgeExportJobRequest.
        Knowledge integration source id.

        :param source_id: The source_id of this KnowledgeExportJobRequest.
        :type: str
        """
        

        self._source_id = source_id

    @property
    def json_file_version(self) -> int:
        """
        Gets the json_file_version of this KnowledgeExportJobRequest.
        Requested version of the exported json file. Available versions are 2 and 3, default is 2

        :return: The json_file_version of this KnowledgeExportJobRequest.
        :rtype: int
        """
        return self._json_file_version

    @json_file_version.setter
    def json_file_version(self, json_file_version: int) -> None:
        """
        Sets the json_file_version of this KnowledgeExportJobRequest.
        Requested version of the exported json file. Available versions are 2 and 3, default is 2

        :param json_file_version: The json_file_version of this KnowledgeExportJobRequest.
        :type: int
        """
        

        self._json_file_version = json_file_version

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

