# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import KnowledgeParseImportResult
    from . import KnowledgeParseRecord
    from . import UserReference

class KnowledgeParseJobResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeParseJobResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'download_url': 'str',
            'hints': 'list[str]',
            'status': 'str',
            'parse_results': 'list[KnowledgeParseRecord]',
            'import_result': 'KnowledgeParseImportResult',
            'created_by': 'UserReference',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'download_url': 'downloadURL',
            'hints': 'hints',
            'status': 'status',
            'parse_results': 'parseResults',
            'import_result': 'importResult',
            'created_by': 'createdBy',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._download_url = None
        self._hints = None
        self._status = None
        self._parse_results = None
        self._import_result = None
        self._created_by = None
        self._date_created = None
        self._date_modified = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this KnowledgeParseJobResponse.
        Id of the parse job

        :return: The id of this KnowledgeParseJobResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this KnowledgeParseJobResponse.
        Id of the parse job

        :param id: The id of this KnowledgeParseJobResponse.
        :type: str
        """
        

        self._id = id

    @property
    def download_url(self) -> str:
        """
        Gets the download_url of this KnowledgeParseJobResponse.
        The URL of the location at which the caller can download the original html file.

        :return: The download_url of this KnowledgeParseJobResponse.
        :rtype: str
        """
        return self._download_url

    @download_url.setter
    def download_url(self, download_url: str) -> None:
        """
        Sets the download_url of this KnowledgeParseJobResponse.
        The URL of the location at which the caller can download the original html file.

        :param download_url: The download_url of this KnowledgeParseJobResponse.
        :type: str
        """
        

        self._download_url = download_url

    @property
    def hints(self) -> List[str]:
        """
        Gets the hints of this KnowledgeParseJobResponse.
        Hinted titles for the parser.

        :return: The hints of this KnowledgeParseJobResponse.
        :rtype: list[str]
        """
        return self._hints

    @hints.setter
    def hints(self, hints: List[str]) -> None:
        """
        Sets the hints of this KnowledgeParseJobResponse.
        Hinted titles for the parser.

        :param hints: The hints of this KnowledgeParseJobResponse.
        :type: list[str]
        """
        

        self._hints = hints

    @property
    def status(self) -> str:
        """
        Gets the status of this KnowledgeParseJobResponse.
        Status of the parse job

        :return: The status of this KnowledgeParseJobResponse.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this KnowledgeParseJobResponse.
        Status of the parse job

        :param status: The status of this KnowledgeParseJobResponse.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["ReadyToParse", "ParseInProgress", "ParseCompleted", "ReadyToImport", "ImportInProgress", "ImportCompleted", "ImportPartialCompleted", "ImportFailed"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def parse_results(self) -> List['KnowledgeParseRecord']:
        """
        Gets the parse_results of this KnowledgeParseJobResponse.
        Results of the parse

        :return: The parse_results of this KnowledgeParseJobResponse.
        :rtype: list[KnowledgeParseRecord]
        """
        return self._parse_results

    @parse_results.setter
    def parse_results(self, parse_results: List['KnowledgeParseRecord']) -> None:
        """
        Sets the parse_results of this KnowledgeParseJobResponse.
        Results of the parse

        :param parse_results: The parse_results of this KnowledgeParseJobResponse.
        :type: list[KnowledgeParseRecord]
        """
        

        self._parse_results = parse_results

    @property
    def import_result(self) -> 'KnowledgeParseImportResult':
        """
        Gets the import_result of this KnowledgeParseJobResponse.
        Result of the import phase

        :return: The import_result of this KnowledgeParseJobResponse.
        :rtype: KnowledgeParseImportResult
        """
        return self._import_result

    @import_result.setter
    def import_result(self, import_result: 'KnowledgeParseImportResult') -> None:
        """
        Sets the import_result of this KnowledgeParseJobResponse.
        Result of the import phase

        :param import_result: The import_result of this KnowledgeParseJobResponse.
        :type: KnowledgeParseImportResult
        """
        

        self._import_result = import_result

    @property
    def created_by(self) -> 'UserReference':
        """
        Gets the created_by of this KnowledgeParseJobResponse.
        The user who created the operation

        :return: The created_by of this KnowledgeParseJobResponse.
        :rtype: UserReference
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'UserReference') -> None:
        """
        Sets the created_by of this KnowledgeParseJobResponse.
        The user who created the operation

        :param created_by: The created_by of this KnowledgeParseJobResponse.
        :type: UserReference
        """
        

        self._created_by = created_by

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this KnowledgeParseJobResponse.
        Created date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this KnowledgeParseJobResponse.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this KnowledgeParseJobResponse.
        Created date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this KnowledgeParseJobResponse.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this KnowledgeParseJobResponse.
        Last modified date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this KnowledgeParseJobResponse.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this KnowledgeParseJobResponse.
        Last modified date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this KnowledgeParseJobResponse.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this KnowledgeParseJobResponse.
        The URI for this object

        :return: The self_uri of this KnowledgeParseJobResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this KnowledgeParseJobResponse.
        The URI for this object

        :param self_uri: The self_uri of this KnowledgeParseJobResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

