# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import KnowledgeBaseReference
    from . import KnowledgeBaseWithDialectReference

class KnowledgeSuggestionConfig(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeSuggestionConfig - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'vendor_name': 'str',
            'knowledge_base': 'KnowledgeBaseReference',
            'knowledge_bases': 'list[KnowledgeBaseWithDialectReference]'
        }

        self.attribute_map = {
            'vendor_name': 'vendorName',
            'knowledge_base': 'knowledgeBase',
            'knowledge_bases': 'knowledgeBases'
        }

        self._vendor_name = None
        self._knowledge_base = None
        self._knowledge_bases = None

    @property
    def vendor_name(self) -> str:
        """
        Gets the vendor_name of this KnowledgeSuggestionConfig.
        The name of vendor used for knowledge suggestions.

        :return: The vendor_name of this KnowledgeSuggestionConfig.
        :rtype: str
        """
        return self._vendor_name

    @vendor_name.setter
    def vendor_name(self, vendor_name: str) -> None:
        """
        Sets the vendor_name of this KnowledgeSuggestionConfig.
        The name of vendor used for knowledge suggestions.

        :param vendor_name: The vendor_name of this KnowledgeSuggestionConfig.
        :type: str
        """
        if isinstance(vendor_name, int):
            vendor_name = str(vendor_name)
        allowed_values = ["GoogleDialogflow", "GenesysKnowledge", "Unknown"]
        if vendor_name.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for vendor_name -> " + vendor_name)
            self._vendor_name = "outdated_sdk_version"
        else:
            self._vendor_name = vendor_name

    @property
    def knowledge_base(self) -> 'KnowledgeBaseReference':
        """
        Gets the knowledge_base of this KnowledgeSuggestionConfig.
        The ID of knowledge base to query when Genesys is the knowledge suggestions provider.

        :return: The knowledge_base of this KnowledgeSuggestionConfig.
        :rtype: KnowledgeBaseReference
        """
        return self._knowledge_base

    @knowledge_base.setter
    def knowledge_base(self, knowledge_base: 'KnowledgeBaseReference') -> None:
        """
        Sets the knowledge_base of this KnowledgeSuggestionConfig.
        The ID of knowledge base to query when Genesys is the knowledge suggestions provider.

        :param knowledge_base: The knowledge_base of this KnowledgeSuggestionConfig.
        :type: KnowledgeBaseReference
        """
        

        self._knowledge_base = knowledge_base

    @property
    def knowledge_bases(self) -> List['KnowledgeBaseWithDialectReference']:
        """
        Gets the knowledge_bases of this KnowledgeSuggestionConfig.
        The knowledge bases to query based on dialect, when Genesys is the knowledge suggestions provider.

        :return: The knowledge_bases of this KnowledgeSuggestionConfig.
        :rtype: list[KnowledgeBaseWithDialectReference]
        """
        return self._knowledge_bases

    @knowledge_bases.setter
    def knowledge_bases(self, knowledge_bases: List['KnowledgeBaseWithDialectReference']) -> None:
        """
        Sets the knowledge_bases of this KnowledgeSuggestionConfig.
        The knowledge bases to query based on dialect, when Genesys is the knowledge suggestions provider.

        :param knowledge_bases: The knowledge_bases of this KnowledgeSuggestionConfig.
        :type: list[KnowledgeBaseWithDialectReference]
        """
        

        self._knowledge_bases = knowledge_bases

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

