# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import KnowledgeBaseReference
    from . import KnowledgeOperationSource
    from . import KnowledgeSyncJobReport
    from . import UserReference

class KnowledgeSyncJobResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeSyncJobResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'upload_key': 'str',
            'status': 'str',
            'report': 'KnowledgeSyncJobReport',
            'knowledge_base': 'KnowledgeBaseReference',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'created_by': 'UserReference',
            'download_url': 'str',
            'failed_entities_url': 'str',
            'source': 'KnowledgeOperationSource',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'upload_key': 'uploadKey',
            'status': 'status',
            'report': 'report',
            'knowledge_base': 'knowledgeBase',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'created_by': 'createdBy',
            'download_url': 'downloadURL',
            'failed_entities_url': 'failedEntitiesURL',
            'source': 'source',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._upload_key = None
        self._status = None
        self._report = None
        self._knowledge_base = None
        self._date_created = None
        self._date_modified = None
        self._created_by = None
        self._download_url = None
        self._failed_entities_url = None
        self._source = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this KnowledgeSyncJobResponse.
        Id of the sync job.

        :return: The id of this KnowledgeSyncJobResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this KnowledgeSyncJobResponse.
        Id of the sync job.

        :param id: The id of this KnowledgeSyncJobResponse.
        :type: str
        """
        

        self._id = id

    @property
    def upload_key(self) -> str:
        """
        Gets the upload_key of this KnowledgeSyncJobResponse.


        :return: The upload_key of this KnowledgeSyncJobResponse.
        :rtype: str
        """
        return self._upload_key

    @upload_key.setter
    def upload_key(self, upload_key: str) -> None:
        """
        Sets the upload_key of this KnowledgeSyncJobResponse.


        :param upload_key: The upload_key of this KnowledgeSyncJobResponse.
        :type: str
        """
        

        self._upload_key = upload_key

    @property
    def status(self) -> str:
        """
        Gets the status of this KnowledgeSyncJobResponse.
        The status of the export job.

        :return: The status of this KnowledgeSyncJobResponse.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this KnowledgeSyncJobResponse.
        The status of the export job.

        :param status: The status of this KnowledgeSyncJobResponse.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Created", "ValidationInProgress", "ValidationCompleted", "ValidationFailed", "Started", "InProgress", "Completed", "PartialCompleted", "Failed", "AbortRequested", "Aborted"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def report(self) -> 'KnowledgeSyncJobReport':
        """
        Gets the report of this KnowledgeSyncJobResponse.
        Report of the sync job

        :return: The report of this KnowledgeSyncJobResponse.
        :rtype: KnowledgeSyncJobReport
        """
        return self._report

    @report.setter
    def report(self, report: 'KnowledgeSyncJobReport') -> None:
        """
        Sets the report of this KnowledgeSyncJobResponse.
        Report of the sync job

        :param report: The report of this KnowledgeSyncJobResponse.
        :type: KnowledgeSyncJobReport
        """
        

        self._report = report

    @property
    def knowledge_base(self) -> 'KnowledgeBaseReference':
        """
        Gets the knowledge_base of this KnowledgeSyncJobResponse.
        Knowledge base which document export belongs to.

        :return: The knowledge_base of this KnowledgeSyncJobResponse.
        :rtype: KnowledgeBaseReference
        """
        return self._knowledge_base

    @knowledge_base.setter
    def knowledge_base(self, knowledge_base: 'KnowledgeBaseReference') -> None:
        """
        Sets the knowledge_base of this KnowledgeSyncJobResponse.
        Knowledge base which document export belongs to.

        :param knowledge_base: The knowledge_base of this KnowledgeSyncJobResponse.
        :type: KnowledgeBaseReference
        """
        

        self._knowledge_base = knowledge_base

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this KnowledgeSyncJobResponse.
        The timestamp of when the export began. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this KnowledgeSyncJobResponse.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this KnowledgeSyncJobResponse.
        The timestamp of when the export began. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this KnowledgeSyncJobResponse.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this KnowledgeSyncJobResponse.
        The timestamp of when the export stopped. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this KnowledgeSyncJobResponse.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this KnowledgeSyncJobResponse.
        The timestamp of when the export stopped. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this KnowledgeSyncJobResponse.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def created_by(self) -> 'UserReference':
        """
        Gets the created_by of this KnowledgeSyncJobResponse.
        The user who created the operation

        :return: The created_by of this KnowledgeSyncJobResponse.
        :rtype: UserReference
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'UserReference') -> None:
        """
        Sets the created_by of this KnowledgeSyncJobResponse.
        The user who created the operation

        :param created_by: The created_by of this KnowledgeSyncJobResponse.
        :type: UserReference
        """
        

        self._created_by = created_by

    @property
    def download_url(self) -> str:
        """
        Gets the download_url of this KnowledgeSyncJobResponse.
        The URL of the location at which the caller can download the sync file, when available.

        :return: The download_url of this KnowledgeSyncJobResponse.
        :rtype: str
        """
        return self._download_url

    @download_url.setter
    def download_url(self, download_url: str) -> None:
        """
        Sets the download_url of this KnowledgeSyncJobResponse.
        The URL of the location at which the caller can download the sync file, when available.

        :param download_url: The download_url of this KnowledgeSyncJobResponse.
        :type: str
        """
        

        self._download_url = download_url

    @property
    def failed_entities_url(self) -> str:
        """
        Gets the failed_entities_url of this KnowledgeSyncJobResponse.
        The URL of the location at which the caller can download the entities in json format that failed during the sync.

        :return: The failed_entities_url of this KnowledgeSyncJobResponse.
        :rtype: str
        """
        return self._failed_entities_url

    @failed_entities_url.setter
    def failed_entities_url(self, failed_entities_url: str) -> None:
        """
        Sets the failed_entities_url of this KnowledgeSyncJobResponse.
        The URL of the location at which the caller can download the entities in json format that failed during the sync.

        :param failed_entities_url: The failed_entities_url of this KnowledgeSyncJobResponse.
        :type: str
        """
        

        self._failed_entities_url = failed_entities_url

    @property
    def source(self) -> 'KnowledgeOperationSource':
        """
        Gets the source of this KnowledgeSyncJobResponse.
        Source of the sync job.

        :return: The source of this KnowledgeSyncJobResponse.
        :rtype: KnowledgeOperationSource
        """
        return self._source

    @source.setter
    def source(self, source: 'KnowledgeOperationSource') -> None:
        """
        Sets the source of this KnowledgeSyncJobResponse.
        Source of the sync job.

        :param source: The source of this KnowledgeSyncJobResponse.
        :type: KnowledgeOperationSource
        """
        

        self._source = source

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this KnowledgeSyncJobResponse.
        The URI for this object

        :return: The self_uri of this KnowledgeSyncJobResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this KnowledgeSyncJobResponse.
        The URI for this object

        :param self_uri: The self_uri of this KnowledgeSyncJobResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

