# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class LastResultByColumnConditionSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LastResultByColumnConditionSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'email_column_name': 'str',
            'email_wrapup_codes': 'list[str]',
            'sms_column_name': 'str',
            'sms_wrapup_codes': 'list[str]'
        }

        self.attribute_map = {
            'email_column_name': 'emailColumnName',
            'email_wrapup_codes': 'emailWrapupCodes',
            'sms_column_name': 'smsColumnName',
            'sms_wrapup_codes': 'smsWrapupCodes'
        }

        self._email_column_name = None
        self._email_wrapup_codes = None
        self._sms_column_name = None
        self._sms_wrapup_codes = None

    @property
    def email_column_name(self) -> str:
        """
        Gets the email_column_name of this LastResultByColumnConditionSettings.
        The name of the contact column to evaluate for Email.

        :return: The email_column_name of this LastResultByColumnConditionSettings.
        :rtype: str
        """
        return self._email_column_name

    @email_column_name.setter
    def email_column_name(self, email_column_name: str) -> None:
        """
        Sets the email_column_name of this LastResultByColumnConditionSettings.
        The name of the contact column to evaluate for Email.

        :param email_column_name: The email_column_name of this LastResultByColumnConditionSettings.
        :type: str
        """
        

        self._email_column_name = email_column_name

    @property
    def email_wrapup_codes(self) -> List[str]:
        """
        Gets the email_wrapup_codes of this LastResultByColumnConditionSettings.
        A list of wrapup code identifiers to match for Email.

        :return: The email_wrapup_codes of this LastResultByColumnConditionSettings.
        :rtype: list[str]
        """
        return self._email_wrapup_codes

    @email_wrapup_codes.setter
    def email_wrapup_codes(self, email_wrapup_codes: List[str]) -> None:
        """
        Sets the email_wrapup_codes of this LastResultByColumnConditionSettings.
        A list of wrapup code identifiers to match for Email.

        :param email_wrapup_codes: The email_wrapup_codes of this LastResultByColumnConditionSettings.
        :type: list[str]
        """
        

        self._email_wrapup_codes = email_wrapup_codes

    @property
    def sms_column_name(self) -> str:
        """
        Gets the sms_column_name of this LastResultByColumnConditionSettings.
        The name of the contact column to evaluate for SMS.

        :return: The sms_column_name of this LastResultByColumnConditionSettings.
        :rtype: str
        """
        return self._sms_column_name

    @sms_column_name.setter
    def sms_column_name(self, sms_column_name: str) -> None:
        """
        Sets the sms_column_name of this LastResultByColumnConditionSettings.
        The name of the contact column to evaluate for SMS.

        :param sms_column_name: The sms_column_name of this LastResultByColumnConditionSettings.
        :type: str
        """
        

        self._sms_column_name = sms_column_name

    @property
    def sms_wrapup_codes(self) -> List[str]:
        """
        Gets the sms_wrapup_codes of this LastResultByColumnConditionSettings.
        A list of wrapup code identifiers to match for SMS.

        :return: The sms_wrapup_codes of this LastResultByColumnConditionSettings.
        :rtype: list[str]
        """
        return self._sms_wrapup_codes

    @sms_wrapup_codes.setter
    def sms_wrapup_codes(self, sms_wrapup_codes: List[str]) -> None:
        """
        Sets the sms_wrapup_codes of this LastResultByColumnConditionSettings.
        A list of wrapup code identifiers to match for SMS.

        :param sms_wrapup_codes: The sms_wrapup_codes of this LastResultByColumnConditionSettings.
        :type: list[str]
        """
        

        self._sms_wrapup_codes = sms_wrapup_codes

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

