# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AssessmentForm
    from . import LearningAssessment
    from . import LearningAssignmentStep
    from . import LearningModule
    from . import UserReference

class LearningAssignment(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LearningAssignment - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'assessment': 'LearningAssessment',
            'created_by': 'UserReference',
            'date_created': 'datetime',
            'modified_by': 'UserReference',
            'date_modified': 'datetime',
            'is_overdue': 'bool',
            'percentage_score': 'float',
            'assessment_percentage_score': 'float',
            'is_rule': 'bool',
            'is_manual': 'bool',
            'is_passed': 'bool',
            'is_latest': 'bool',
            'assessment_completion_percentage': 'float',
            'completion_percentage': 'float',
            'steps': 'list[LearningAssignmentStep]',
            'next_step': 'LearningAssignmentStep',
            'self_uri': 'str',
            'state': 'str',
            'date_recommended_for_completion': 'datetime',
            'version': 'int',
            'module': 'LearningModule',
            'user': 'UserReference',
            'assessment_form': 'AssessmentForm',
            'length_in_minutes': 'int'
        }

        self.attribute_map = {
            'id': 'id',
            'assessment': 'assessment',
            'created_by': 'createdBy',
            'date_created': 'dateCreated',
            'modified_by': 'modifiedBy',
            'date_modified': 'dateModified',
            'is_overdue': 'isOverdue',
            'percentage_score': 'percentageScore',
            'assessment_percentage_score': 'assessmentPercentageScore',
            'is_rule': 'isRule',
            'is_manual': 'isManual',
            'is_passed': 'isPassed',
            'is_latest': 'isLatest',
            'assessment_completion_percentage': 'assessmentCompletionPercentage',
            'completion_percentage': 'completionPercentage',
            'steps': 'steps',
            'next_step': 'nextStep',
            'self_uri': 'selfUri',
            'state': 'state',
            'date_recommended_for_completion': 'dateRecommendedForCompletion',
            'version': 'version',
            'module': 'module',
            'user': 'user',
            'assessment_form': 'assessmentForm',
            'length_in_minutes': 'lengthInMinutes'
        }

        self._id = None
        self._assessment = None
        self._created_by = None
        self._date_created = None
        self._modified_by = None
        self._date_modified = None
        self._is_overdue = None
        self._percentage_score = None
        self._assessment_percentage_score = None
        self._is_rule = None
        self._is_manual = None
        self._is_passed = None
        self._is_latest = None
        self._assessment_completion_percentage = None
        self._completion_percentage = None
        self._steps = None
        self._next_step = None
        self._self_uri = None
        self._state = None
        self._date_recommended_for_completion = None
        self._version = None
        self._module = None
        self._user = None
        self._assessment_form = None
        self._length_in_minutes = None

    @property
    def id(self) -> str:
        """
        Gets the id of this LearningAssignment.
        The globally unique identifier for the object.

        :return: The id of this LearningAssignment.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this LearningAssignment.
        The globally unique identifier for the object.

        :param id: The id of this LearningAssignment.
        :type: str
        """
        

        self._id = id

    @property
    def assessment(self) -> 'LearningAssessment':
        """
        Gets the assessment of this LearningAssignment.
        The assessment associated with this assignment

        :return: The assessment of this LearningAssignment.
        :rtype: LearningAssessment
        """
        return self._assessment

    @assessment.setter
    def assessment(self, assessment: 'LearningAssessment') -> None:
        """
        Sets the assessment of this LearningAssignment.
        The assessment associated with this assignment

        :param assessment: The assessment of this LearningAssignment.
        :type: LearningAssessment
        """
        

        self._assessment = assessment

    @property
    def created_by(self) -> 'UserReference':
        """
        Gets the created_by of this LearningAssignment.
        The user who created the assignment

        :return: The created_by of this LearningAssignment.
        :rtype: UserReference
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'UserReference') -> None:
        """
        Sets the created_by of this LearningAssignment.
        The user who created the assignment

        :param created_by: The created_by of this LearningAssignment.
        :type: UserReference
        """
        

        self._created_by = created_by

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this LearningAssignment.
        The date when the assignment was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this LearningAssignment.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this LearningAssignment.
        The date when the assignment was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this LearningAssignment.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def modified_by(self) -> 'UserReference':
        """
        Gets the modified_by of this LearningAssignment.
        The user who modified the assignment

        :return: The modified_by of this LearningAssignment.
        :rtype: UserReference
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by: 'UserReference') -> None:
        """
        Sets the modified_by of this LearningAssignment.
        The user who modified the assignment

        :param modified_by: The modified_by of this LearningAssignment.
        :type: UserReference
        """
        

        self._modified_by = modified_by

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this LearningAssignment.
        The date when the assignment was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this LearningAssignment.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this LearningAssignment.
        The date when the assignment was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this LearningAssignment.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def is_overdue(self) -> bool:
        """
        Gets the is_overdue of this LearningAssignment.
        True if the assignment is overdue

        :return: The is_overdue of this LearningAssignment.
        :rtype: bool
        """
        return self._is_overdue

    @is_overdue.setter
    def is_overdue(self, is_overdue: bool) -> None:
        """
        Sets the is_overdue of this LearningAssignment.
        True if the assignment is overdue

        :param is_overdue: The is_overdue of this LearningAssignment.
        :type: bool
        """
        

        self._is_overdue = is_overdue

    @property
    def percentage_score(self) -> float:
        """
        Gets the percentage_score of this LearningAssignment.
        The user's percentage score for this assignment

        :return: The percentage_score of this LearningAssignment.
        :rtype: float
        """
        return self._percentage_score

    @percentage_score.setter
    def percentage_score(self, percentage_score: float) -> None:
        """
        Sets the percentage_score of this LearningAssignment.
        The user's percentage score for this assignment

        :param percentage_score: The percentage_score of this LearningAssignment.
        :type: float
        """
        

        self._percentage_score = percentage_score

    @property
    def assessment_percentage_score(self) -> float:
        """
        Gets the assessment_percentage_score of this LearningAssignment.
        The user's percentage score for this assignment's assessment

        :return: The assessment_percentage_score of this LearningAssignment.
        :rtype: float
        """
        return self._assessment_percentage_score

    @assessment_percentage_score.setter
    def assessment_percentage_score(self, assessment_percentage_score: float) -> None:
        """
        Sets the assessment_percentage_score of this LearningAssignment.
        The user's percentage score for this assignment's assessment

        :param assessment_percentage_score: The assessment_percentage_score of this LearningAssignment.
        :type: float
        """
        

        self._assessment_percentage_score = assessment_percentage_score

    @property
    def is_rule(self) -> bool:
        """
        Gets the is_rule of this LearningAssignment.
        True if this assignment was created by a Rule

        :return: The is_rule of this LearningAssignment.
        :rtype: bool
        """
        return self._is_rule

    @is_rule.setter
    def is_rule(self, is_rule: bool) -> None:
        """
        Sets the is_rule of this LearningAssignment.
        True if this assignment was created by a Rule

        :param is_rule: The is_rule of this LearningAssignment.
        :type: bool
        """
        

        self._is_rule = is_rule

    @property
    def is_manual(self) -> bool:
        """
        Gets the is_manual of this LearningAssignment.
        True if this assignment was created manually

        :return: The is_manual of this LearningAssignment.
        :rtype: bool
        """
        return self._is_manual

    @is_manual.setter
    def is_manual(self, is_manual: bool) -> None:
        """
        Sets the is_manual of this LearningAssignment.
        True if this assignment was created manually

        :param is_manual: The is_manual of this LearningAssignment.
        :type: bool
        """
        

        self._is_manual = is_manual

    @property
    def is_passed(self) -> bool:
        """
        Gets the is_passed of this LearningAssignment.
        True if the assessment was passed

        :return: The is_passed of this LearningAssignment.
        :rtype: bool
        """
        return self._is_passed

    @is_passed.setter
    def is_passed(self, is_passed: bool) -> None:
        """
        Sets the is_passed of this LearningAssignment.
        True if the assessment was passed

        :param is_passed: The is_passed of this LearningAssignment.
        :type: bool
        """
        

        self._is_passed = is_passed

    @property
    def is_latest(self) -> bool:
        """
        Gets the is_latest of this LearningAssignment.
        True if the assignment is based on latest module

        :return: The is_latest of this LearningAssignment.
        :rtype: bool
        """
        return self._is_latest

    @is_latest.setter
    def is_latest(self, is_latest: bool) -> None:
        """
        Sets the is_latest of this LearningAssignment.
        True if the assignment is based on latest module

        :param is_latest: The is_latest of this LearningAssignment.
        :type: bool
        """
        

        self._is_latest = is_latest

    @property
    def assessment_completion_percentage(self) -> float:
        """
        Gets the assessment_completion_percentage of this LearningAssignment.
        The assessment completion percentage of assignment

        :return: The assessment_completion_percentage of this LearningAssignment.
        :rtype: float
        """
        return self._assessment_completion_percentage

    @assessment_completion_percentage.setter
    def assessment_completion_percentage(self, assessment_completion_percentage: float) -> None:
        """
        Sets the assessment_completion_percentage of this LearningAssignment.
        The assessment completion percentage of assignment

        :param assessment_completion_percentage: The assessment_completion_percentage of this LearningAssignment.
        :type: float
        """
        

        self._assessment_completion_percentage = assessment_completion_percentage

    @property
    def completion_percentage(self) -> float:
        """
        Gets the completion_percentage of this LearningAssignment.
        The overall completion percentage of assignment

        :return: The completion_percentage of this LearningAssignment.
        :rtype: float
        """
        return self._completion_percentage

    @completion_percentage.setter
    def completion_percentage(self, completion_percentage: float) -> None:
        """
        Sets the completion_percentage of this LearningAssignment.
        The overall completion percentage of assignment

        :param completion_percentage: The completion_percentage of this LearningAssignment.
        :type: float
        """
        

        self._completion_percentage = completion_percentage

    @property
    def steps(self) -> List['LearningAssignmentStep']:
        """
        Gets the steps of this LearningAssignment.
        List of assignment steps

        :return: The steps of this LearningAssignment.
        :rtype: list[LearningAssignmentStep]
        """
        return self._steps

    @steps.setter
    def steps(self, steps: List['LearningAssignmentStep']) -> None:
        """
        Sets the steps of this LearningAssignment.
        List of assignment steps

        :param steps: The steps of this LearningAssignment.
        :type: list[LearningAssignmentStep]
        """
        

        self._steps = steps

    @property
    def next_step(self) -> 'LearningAssignmentStep':
        """
        Gets the next_step of this LearningAssignment.
        The next assignment step

        :return: The next_step of this LearningAssignment.
        :rtype: LearningAssignmentStep
        """
        return self._next_step

    @next_step.setter
    def next_step(self, next_step: 'LearningAssignmentStep') -> None:
        """
        Sets the next_step of this LearningAssignment.
        The next assignment step

        :param next_step: The next_step of this LearningAssignment.
        :type: LearningAssignmentStep
        """
        

        self._next_step = next_step

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this LearningAssignment.
        The URI for this object

        :return: The self_uri of this LearningAssignment.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this LearningAssignment.
        The URI for this object

        :param self_uri: The self_uri of this LearningAssignment.
        :type: str
        """
        

        self._self_uri = self_uri

    @property
    def state(self) -> str:
        """
        Gets the state of this LearningAssignment.
        The Learning Assignment state

        :return: The state of this LearningAssignment.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this LearningAssignment.
        The Learning Assignment state

        :param state: The state of this LearningAssignment.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Assigned", "InProgress", "Completed", "Deleted", "NotCompleted", "InvalidSchedule"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def date_recommended_for_completion(self) -> datetime:
        """
        Gets the date_recommended_for_completion of this LearningAssignment.
        The recommended completion date of the assignment. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_recommended_for_completion of this LearningAssignment.
        :rtype: datetime
        """
        return self._date_recommended_for_completion

    @date_recommended_for_completion.setter
    def date_recommended_for_completion(self, date_recommended_for_completion: datetime) -> None:
        """
        Sets the date_recommended_for_completion of this LearningAssignment.
        The recommended completion date of the assignment. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_recommended_for_completion: The date_recommended_for_completion of this LearningAssignment.
        :type: datetime
        """
        

        self._date_recommended_for_completion = date_recommended_for_completion

    @property
    def version(self) -> int:
        """
        Gets the version of this LearningAssignment.
        The version of Learning module assigned

        :return: The version of this LearningAssignment.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this LearningAssignment.
        The version of Learning module assigned

        :param version: The version of this LearningAssignment.
        :type: int
        """
        

        self._version = version

    @property
    def module(self) -> 'LearningModule':
        """
        Gets the module of this LearningAssignment.
        The Learning module object associated with this assignment

        :return: The module of this LearningAssignment.
        :rtype: LearningModule
        """
        return self._module

    @module.setter
    def module(self, module: 'LearningModule') -> None:
        """
        Sets the module of this LearningAssignment.
        The Learning module object associated with this assignment

        :param module: The module of this LearningAssignment.
        :type: LearningModule
        """
        

        self._module = module

    @property
    def user(self) -> 'UserReference':
        """
        Gets the user of this LearningAssignment.
        The user to whom the assignment is assigned

        :return: The user of this LearningAssignment.
        :rtype: UserReference
        """
        return self._user

    @user.setter
    def user(self, user: 'UserReference') -> None:
        """
        Sets the user of this LearningAssignment.
        The user to whom the assignment is assigned

        :param user: The user of this LearningAssignment.
        :type: UserReference
        """
        

        self._user = user

    @property
    def assessment_form(self) -> 'AssessmentForm':
        """
        Gets the assessment_form of this LearningAssignment.
        The assessment form associated with this assignment

        :return: The assessment_form of this LearningAssignment.
        :rtype: AssessmentForm
        """
        return self._assessment_form

    @assessment_form.setter
    def assessment_form(self, assessment_form: 'AssessmentForm') -> None:
        """
        Sets the assessment_form of this LearningAssignment.
        The assessment form associated with this assignment

        :param assessment_form: The assessment_form of this LearningAssignment.
        :type: AssessmentForm
        """
        

        self._assessment_form = assessment_form

    @property
    def length_in_minutes(self) -> int:
        """
        Gets the length_in_minutes of this LearningAssignment.
        The length in minutes of the assignment

        :return: The length_in_minutes of this LearningAssignment.
        :rtype: int
        """
        return self._length_in_minutes

    @length_in_minutes.setter
    def length_in_minutes(self, length_in_minutes: int) -> None:
        """
        Sets the length_in_minutes of this LearningAssignment.
        The length in minutes of the assignment

        :param length_in_minutes: The length_in_minutes of this LearningAssignment.
        :type: int
        """
        

        self._length_in_minutes = length_in_minutes

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

