# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class LearningAssignmentReschedule(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LearningAssignmentReschedule - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'date_recommended_for_completion': 'datetime',
            'length_in_minutes': 'int'
        }

        self.attribute_map = {
            'date_recommended_for_completion': 'dateRecommendedForCompletion',
            'length_in_minutes': 'lengthInMinutes'
        }

        self._date_recommended_for_completion = None
        self._length_in_minutes = None

    @property
    def date_recommended_for_completion(self) -> datetime:
        """
        Gets the date_recommended_for_completion of this LearningAssignmentReschedule.
        The recommended completion date of the assignment. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_recommended_for_completion of this LearningAssignmentReschedule.
        :rtype: datetime
        """
        return self._date_recommended_for_completion

    @date_recommended_for_completion.setter
    def date_recommended_for_completion(self, date_recommended_for_completion: datetime) -> None:
        """
        Sets the date_recommended_for_completion of this LearningAssignmentReschedule.
        The recommended completion date of the assignment. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_recommended_for_completion: The date_recommended_for_completion of this LearningAssignmentReschedule.
        :type: datetime
        """
        

        self._date_recommended_for_completion = date_recommended_for_completion

    @property
    def length_in_minutes(self) -> int:
        """
        Gets the length_in_minutes of this LearningAssignmentReschedule.
        The length in minutes of the assignment

        :return: The length_in_minutes of this LearningAssignmentReschedule.
        :rtype: int
        """
        return self._length_in_minutes

    @length_in_minutes.setter
    def length_in_minutes(self, length_in_minutes: int) -> None:
        """
        Sets the length_in_minutes of this LearningAssignmentReschedule.
        The length in minutes of the assignment

        :param length_in_minutes: The length_in_minutes of this LearningAssignmentReschedule.
        :type: int
        """
        

        self._length_in_minutes = length_in_minutes

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

