# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import LearningAssignmentStepScoStructure
    from . import LearningAssignmentStepSignedCookie
    from . import LearningModuleInformStep
    from . import LearningShareableContentObject

class LearningAssignmentStep(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LearningAssignmentStep - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'module_step': 'LearningModuleInformStep',
            'structure': 'list[LearningAssignmentStepScoStructure]',
            'success_status': 'str',
            'completion_status': 'str',
            'completion_percentage': 'float',
            'percentage_score': 'float',
            'shareable_content_object': 'LearningShareableContentObject',
            'signed_cookie': 'LearningAssignmentStepSignedCookie',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'module_step': 'moduleStep',
            'structure': 'structure',
            'success_status': 'successStatus',
            'completion_status': 'completionStatus',
            'completion_percentage': 'completionPercentage',
            'percentage_score': 'percentageScore',
            'shareable_content_object': 'shareableContentObject',
            'signed_cookie': 'signedCookie',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._module_step = None
        self._structure = None
        self._success_status = None
        self._completion_status = None
        self._completion_percentage = None
        self._percentage_score = None
        self._shareable_content_object = None
        self._signed_cookie = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this LearningAssignmentStep.
        The ID of the learning assignment step

        :return: The id of this LearningAssignmentStep.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this LearningAssignmentStep.
        The ID of the learning assignment step

        :param id: The id of this LearningAssignmentStep.
        :type: str
        """
        

        self._id = id

    @property
    def module_step(self) -> 'LearningModuleInformStep':
        """
        Gets the module_step of this LearningAssignmentStep.
        The module step data for this step

        :return: The module_step of this LearningAssignmentStep.
        :rtype: LearningModuleInformStep
        """
        return self._module_step

    @module_step.setter
    def module_step(self, module_step: 'LearningModuleInformStep') -> None:
        """
        Sets the module_step of this LearningAssignmentStep.
        The module step data for this step

        :param module_step: The module_step of this LearningAssignmentStep.
        :type: LearningModuleInformStep
        """
        

        self._module_step = module_step

    @property
    def structure(self) -> List['LearningAssignmentStepScoStructure']:
        """
        Gets the structure of this LearningAssignmentStep.
        The structure for any SCO associated with this step

        :return: The structure of this LearningAssignmentStep.
        :rtype: list[LearningAssignmentStepScoStructure]
        """
        return self._structure

    @structure.setter
    def structure(self, structure: List['LearningAssignmentStepScoStructure']) -> None:
        """
        Sets the structure of this LearningAssignmentStep.
        The structure for any SCO associated with this step

        :param structure: The structure of this LearningAssignmentStep.
        :type: list[LearningAssignmentStepScoStructure]
        """
        

        self._structure = structure

    @property
    def success_status(self) -> str:
        """
        Gets the success_status of this LearningAssignmentStep.
        The success status of this step

        :return: The success_status of this LearningAssignmentStep.
        :rtype: str
        """
        return self._success_status

    @success_status.setter
    def success_status(self, success_status: str) -> None:
        """
        Sets the success_status of this LearningAssignmentStep.
        The success status of this step

        :param success_status: The success_status of this LearningAssignmentStep.
        :type: str
        """
        if isinstance(success_status, int):
            success_status = str(success_status)
        allowed_values = ["Passed", "Failed", "Unknown"]
        if success_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for success_status -> " + success_status)
            self._success_status = "outdated_sdk_version"
        else:
            self._success_status = success_status

    @property
    def completion_status(self) -> str:
        """
        Gets the completion_status of this LearningAssignmentStep.
        The completion status of the assignment step

        :return: The completion_status of this LearningAssignmentStep.
        :rtype: str
        """
        return self._completion_status

    @completion_status.setter
    def completion_status(self, completion_status: str) -> None:
        """
        Sets the completion_status of this LearningAssignmentStep.
        The completion status of the assignment step

        :param completion_status: The completion_status of this LearningAssignmentStep.
        :type: str
        """
        if isinstance(completion_status, int):
            completion_status = str(completion_status)
        allowed_values = ["Completed", "Incomplete", "NotAttempted", "Unknown"]
        if completion_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for completion_status -> " + completion_status)
            self._completion_status = "outdated_sdk_version"
        else:
            self._completion_status = completion_status

    @property
    def completion_percentage(self) -> float:
        """
        Gets the completion_percentage of this LearningAssignmentStep.
        The completion percentage for this step

        :return: The completion_percentage of this LearningAssignmentStep.
        :rtype: float
        """
        return self._completion_percentage

    @completion_percentage.setter
    def completion_percentage(self, completion_percentage: float) -> None:
        """
        Sets the completion_percentage of this LearningAssignmentStep.
        The completion percentage for this step

        :param completion_percentage: The completion_percentage of this LearningAssignmentStep.
        :type: float
        """
        

        self._completion_percentage = completion_percentage

    @property
    def percentage_score(self) -> float:
        """
        Gets the percentage_score of this LearningAssignmentStep.
        The percentage score for this step

        :return: The percentage_score of this LearningAssignmentStep.
        :rtype: float
        """
        return self._percentage_score

    @percentage_score.setter
    def percentage_score(self, percentage_score: float) -> None:
        """
        Sets the percentage_score of this LearningAssignmentStep.
        The percentage score for this step

        :param percentage_score: The percentage_score of this LearningAssignmentStep.
        :type: float
        """
        

        self._percentage_score = percentage_score

    @property
    def shareable_content_object(self) -> 'LearningShareableContentObject':
        """
        Gets the shareable_content_object of this LearningAssignmentStep.
        The SCO (Shareable Content Object) data

        :return: The shareable_content_object of this LearningAssignmentStep.
        :rtype: LearningShareableContentObject
        """
        return self._shareable_content_object

    @shareable_content_object.setter
    def shareable_content_object(self, shareable_content_object: 'LearningShareableContentObject') -> None:
        """
        Sets the shareable_content_object of this LearningAssignmentStep.
        The SCO (Shareable Content Object) data

        :param shareable_content_object: The shareable_content_object of this LearningAssignmentStep.
        :type: LearningShareableContentObject
        """
        

        self._shareable_content_object = shareable_content_object

    @property
    def signed_cookie(self) -> 'LearningAssignmentStepSignedCookie':
        """
        Gets the signed_cookie of this LearningAssignmentStep.
        The signed cookie information needed to access the content of this step (if required)

        :return: The signed_cookie of this LearningAssignmentStep.
        :rtype: LearningAssignmentStepSignedCookie
        """
        return self._signed_cookie

    @signed_cookie.setter
    def signed_cookie(self, signed_cookie: 'LearningAssignmentStepSignedCookie') -> None:
        """
        Sets the signed_cookie of this LearningAssignmentStep.
        The signed cookie information needed to access the content of this step (if required)

        :param signed_cookie: The signed_cookie of this LearningAssignmentStep.
        :type: LearningAssignmentStepSignedCookie
        """
        

        self._signed_cookie = signed_cookie

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this LearningAssignmentStep.
        The URI for this object

        :return: The self_uri of this LearningAssignmentStep.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this LearningAssignmentStep.
        The URI for this object

        :param self_uri: The self_uri of this LearningAssignmentStep.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

