# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import LearningModulePreviewGetResponseStep

class LearningModulePreviewGetResponseAssignment(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LearningModulePreviewGetResponseAssignment - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'state': 'str',
            'percentage_score': 'float',
            'assessment_percentage_score': 'float',
            'is_passed': 'bool',
            'assessment_completion_percentage': 'float',
            'completion_percentage': 'float',
            'steps': 'list[LearningModulePreviewGetResponseStep]'
        }

        self.attribute_map = {
            'state': 'state',
            'percentage_score': 'percentageScore',
            'assessment_percentage_score': 'assessmentPercentageScore',
            'is_passed': 'isPassed',
            'assessment_completion_percentage': 'assessmentCompletionPercentage',
            'completion_percentage': 'completionPercentage',
            'steps': 'steps'
        }

        self._state = None
        self._percentage_score = None
        self._assessment_percentage_score = None
        self._is_passed = None
        self._assessment_completion_percentage = None
        self._completion_percentage = None
        self._steps = None

    @property
    def state(self) -> str:
        """
        Gets the state of this LearningModulePreviewGetResponseAssignment.
        The Learning Assignment state

        :return: The state of this LearningModulePreviewGetResponseAssignment.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this LearningModulePreviewGetResponseAssignment.
        The Learning Assignment state

        :param state: The state of this LearningModulePreviewGetResponseAssignment.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Assigned", "InProgress", "Completed", "Deleted", "NotCompleted", "InvalidSchedule"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def percentage_score(self) -> float:
        """
        Gets the percentage_score of this LearningModulePreviewGetResponseAssignment.
        The user's percentage score for this assignment

        :return: The percentage_score of this LearningModulePreviewGetResponseAssignment.
        :rtype: float
        """
        return self._percentage_score

    @percentage_score.setter
    def percentage_score(self, percentage_score: float) -> None:
        """
        Sets the percentage_score of this LearningModulePreviewGetResponseAssignment.
        The user's percentage score for this assignment

        :param percentage_score: The percentage_score of this LearningModulePreviewGetResponseAssignment.
        :type: float
        """
        

        self._percentage_score = percentage_score

    @property
    def assessment_percentage_score(self) -> float:
        """
        Gets the assessment_percentage_score of this LearningModulePreviewGetResponseAssignment.
        The user's percentage score for this assignment's assessment

        :return: The assessment_percentage_score of this LearningModulePreviewGetResponseAssignment.
        :rtype: float
        """
        return self._assessment_percentage_score

    @assessment_percentage_score.setter
    def assessment_percentage_score(self, assessment_percentage_score: float) -> None:
        """
        Sets the assessment_percentage_score of this LearningModulePreviewGetResponseAssignment.
        The user's percentage score for this assignment's assessment

        :param assessment_percentage_score: The assessment_percentage_score of this LearningModulePreviewGetResponseAssignment.
        :type: float
        """
        

        self._assessment_percentage_score = assessment_percentage_score

    @property
    def is_passed(self) -> bool:
        """
        Gets the is_passed of this LearningModulePreviewGetResponseAssignment.
        True if the assessment was passed

        :return: The is_passed of this LearningModulePreviewGetResponseAssignment.
        :rtype: bool
        """
        return self._is_passed

    @is_passed.setter
    def is_passed(self, is_passed: bool) -> None:
        """
        Sets the is_passed of this LearningModulePreviewGetResponseAssignment.
        True if the assessment was passed

        :param is_passed: The is_passed of this LearningModulePreviewGetResponseAssignment.
        :type: bool
        """
        

        self._is_passed = is_passed

    @property
    def assessment_completion_percentage(self) -> float:
        """
        Gets the assessment_completion_percentage of this LearningModulePreviewGetResponseAssignment.
        The assessment completion percentage of assignment

        :return: The assessment_completion_percentage of this LearningModulePreviewGetResponseAssignment.
        :rtype: float
        """
        return self._assessment_completion_percentage

    @assessment_completion_percentage.setter
    def assessment_completion_percentage(self, assessment_completion_percentage: float) -> None:
        """
        Sets the assessment_completion_percentage of this LearningModulePreviewGetResponseAssignment.
        The assessment completion percentage of assignment

        :param assessment_completion_percentage: The assessment_completion_percentage of this LearningModulePreviewGetResponseAssignment.
        :type: float
        """
        

        self._assessment_completion_percentage = assessment_completion_percentage

    @property
    def completion_percentage(self) -> float:
        """
        Gets the completion_percentage of this LearningModulePreviewGetResponseAssignment.
        The overall completion percentage of assignment

        :return: The completion_percentage of this LearningModulePreviewGetResponseAssignment.
        :rtype: float
        """
        return self._completion_percentage

    @completion_percentage.setter
    def completion_percentage(self, completion_percentage: float) -> None:
        """
        Sets the completion_percentage of this LearningModulePreviewGetResponseAssignment.
        The overall completion percentage of assignment

        :param completion_percentage: The completion_percentage of this LearningModulePreviewGetResponseAssignment.
        :type: float
        """
        

        self._completion_percentage = completion_percentage

    @property
    def steps(self) -> List['LearningModulePreviewGetResponseStep']:
        """
        Gets the steps of this LearningModulePreviewGetResponseAssignment.
        List of assignment steps

        :return: The steps of this LearningModulePreviewGetResponseAssignment.
        :rtype: list[LearningModulePreviewGetResponseStep]
        """
        return self._steps

    @steps.setter
    def steps(self, steps: List['LearningModulePreviewGetResponseStep']) -> None:
        """
        Sets the steps of this LearningModulePreviewGetResponseAssignment.
        List of assignment steps

        :param steps: The steps of this LearningModulePreviewGetResponseAssignment.
        :type: list[LearningModulePreviewGetResponseStep]
        """
        

        self._steps = steps

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

