# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import LearningShareableContentObject

class LearningModulePreviewUpdateRequestCurrentStep(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LearningModulePreviewUpdateRequestCurrentStep - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'completion_percentage': 'float',
            'shareable_content_object': 'LearningShareableContentObject'
        }

        self.attribute_map = {
            'id': 'id',
            'completion_percentage': 'completionPercentage',
            'shareable_content_object': 'shareableContentObject'
        }

        self._id = None
        self._completion_percentage = None
        self._shareable_content_object = None

    @property
    def id(self) -> str:
        """
        Gets the id of this LearningModulePreviewUpdateRequestCurrentStep.
        The id of this step

        :return: The id of this LearningModulePreviewUpdateRequestCurrentStep.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this LearningModulePreviewUpdateRequestCurrentStep.
        The id of this step

        :param id: The id of this LearningModulePreviewUpdateRequestCurrentStep.
        :type: str
        """
        

        self._id = id

    @property
    def completion_percentage(self) -> float:
        """
        Gets the completion_percentage of this LearningModulePreviewUpdateRequestCurrentStep.
        The completion percentage for this step

        :return: The completion_percentage of this LearningModulePreviewUpdateRequestCurrentStep.
        :rtype: float
        """
        return self._completion_percentage

    @completion_percentage.setter
    def completion_percentage(self, completion_percentage: float) -> None:
        """
        Sets the completion_percentage of this LearningModulePreviewUpdateRequestCurrentStep.
        The completion percentage for this step

        :param completion_percentage: The completion_percentage of this LearningModulePreviewUpdateRequestCurrentStep.
        :type: float
        """
        

        self._completion_percentage = completion_percentage

    @property
    def shareable_content_object(self) -> 'LearningShareableContentObject':
        """
        Gets the shareable_content_object of this LearningModulePreviewUpdateRequestCurrentStep.
        The SCO (Shareable Content Object) data

        :return: The shareable_content_object of this LearningModulePreviewUpdateRequestCurrentStep.
        :rtype: LearningShareableContentObject
        """
        return self._shareable_content_object

    @shareable_content_object.setter
    def shareable_content_object(self, shareable_content_object: 'LearningShareableContentObject') -> None:
        """
        Sets the shareable_content_object of this LearningModulePreviewUpdateRequestCurrentStep.
        The SCO (Shareable Content Object) data

        :param shareable_content_object: The shareable_content_object of this LearningModulePreviewUpdateRequestCurrentStep.
        :type: LearningShareableContentObject
        """
        

        self._shareable_content_object = shareable_content_object

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

