# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class LearningShareableContentObject(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LearningShareableContentObject - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'lesson_status': 'str',
            'exit': 'str',
            'location': 'str',
            'score_raw': 'float',
            'score_max': 'float',
            'score_min': 'float',
            'suspend_data': 'str',
            'credit': 'str',
            'entry': 'str',
            'mode': 'str',
            'total_time': 'str',
            'session_time': 'str',
            'href': 'str',
            'parameters': 'str',
            'launch_data': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'lesson_status': 'lessonStatus',
            'exit': 'exit',
            'location': 'location',
            'score_raw': 'scoreRaw',
            'score_max': 'scoreMax',
            'score_min': 'scoreMin',
            'suspend_data': 'suspendData',
            'credit': 'credit',
            'entry': 'entry',
            'mode': 'mode',
            'total_time': 'totalTime',
            'session_time': 'sessionTime',
            'href': 'href',
            'parameters': 'parameters',
            'launch_data': 'launchData'
        }

        self._id = None
        self._lesson_status = None
        self._exit = None
        self._location = None
        self._score_raw = None
        self._score_max = None
        self._score_min = None
        self._suspend_data = None
        self._credit = None
        self._entry = None
        self._mode = None
        self._total_time = None
        self._session_time = None
        self._href = None
        self._parameters = None
        self._launch_data = None

    @property
    def id(self) -> str:
        """
        Gets the id of this LearningShareableContentObject.
        The ID of the SCO from the course manifest.

        :return: The id of this LearningShareableContentObject.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this LearningShareableContentObject.
        The ID of the SCO from the course manifest.

        :param id: The id of this LearningShareableContentObject.
        :type: str
        """
        

        self._id = id

    @property
    def lesson_status(self) -> str:
        """
        Gets the lesson_status of this LearningShareableContentObject.
        The status of the SCO. Maps to the SCORM 1.2 cmi.core.lesson_status property.

        :return: The lesson_status of this LearningShareableContentObject.
        :rtype: str
        """
        return self._lesson_status

    @lesson_status.setter
    def lesson_status(self, lesson_status: str) -> None:
        """
        Sets the lesson_status of this LearningShareableContentObject.
        The status of the SCO. Maps to the SCORM 1.2 cmi.core.lesson_status property.

        :param lesson_status: The lesson_status of this LearningShareableContentObject.
        :type: str
        """
        if isinstance(lesson_status, int):
            lesson_status = str(lesson_status)
        allowed_values = ["Passed", "Completed", "Failed", "Incomplete", "Browsed", "NotAttempted"]
        if lesson_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for lesson_status -> " + lesson_status)
            self._lesson_status = "outdated_sdk_version"
        else:
            self._lesson_status = lesson_status

    @property
    def exit(self) -> str:
        """
        Gets the exit of this LearningShareableContentObject.
        Indicates how or why the learner left the SCO. Maps to the SCORM 1.2 cmi.core.exit property.

        :return: The exit of this LearningShareableContentObject.
        :rtype: str
        """
        return self._exit

    @exit.setter
    def exit(self, exit: str) -> None:
        """
        Sets the exit of this LearningShareableContentObject.
        Indicates how or why the learner left the SCO. Maps to the SCORM 1.2 cmi.core.exit property.

        :param exit: The exit of this LearningShareableContentObject.
        :type: str
        """
        if isinstance(exit, int):
            exit = str(exit)
        allowed_values = ["Timeout", "Suspend", "Logout", "Empty"]
        if exit.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for exit -> " + exit)
            self._exit = "outdated_sdk_version"
        else:
            self._exit = exit

    @property
    def location(self) -> str:
        """
        Gets the location of this LearningShareableContentObject.
        The learner’s current location in the SCO. Maps to the SCORM 1.2 cmi.core.lesson_location property.

        :return: The location of this LearningShareableContentObject.
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location: str) -> None:
        """
        Sets the location of this LearningShareableContentObject.
        The learner’s current location in the SCO. Maps to the SCORM 1.2 cmi.core.lesson_location property.

        :param location: The location of this LearningShareableContentObject.
        :type: str
        """
        

        self._location = location

    @property
    def score_raw(self) -> float:
        """
        Gets the score_raw of this LearningShareableContentObject.
        The score of the most recent attempt on the SCO. Maps to the SCORM 1.2 cmi.core.score.raw property.

        :return: The score_raw of this LearningShareableContentObject.
        :rtype: float
        """
        return self._score_raw

    @score_raw.setter
    def score_raw(self, score_raw: float) -> None:
        """
        Sets the score_raw of this LearningShareableContentObject.
        The score of the most recent attempt on the SCO. Maps to the SCORM 1.2 cmi.core.score.raw property.

        :param score_raw: The score_raw of this LearningShareableContentObject.
        :type: float
        """
        

        self._score_raw = score_raw

    @property
    def score_max(self) -> float:
        """
        Gets the score_max of this LearningShareableContentObject.
        The maximum score that could be achieved on the SCO. Maps to the SCORM 1.2 cmi.core.score.max property.

        :return: The score_max of this LearningShareableContentObject.
        :rtype: float
        """
        return self._score_max

    @score_max.setter
    def score_max(self, score_max: float) -> None:
        """
        Sets the score_max of this LearningShareableContentObject.
        The maximum score that could be achieved on the SCO. Maps to the SCORM 1.2 cmi.core.score.max property.

        :param score_max: The score_max of this LearningShareableContentObject.
        :type: float
        """
        

        self._score_max = score_max

    @property
    def score_min(self) -> float:
        """
        Gets the score_min of this LearningShareableContentObject.
        The minimum score that could be achieved on the SCO. Maps to the SCORM 1.2 cmi.core.score.min property.

        :return: The score_min of this LearningShareableContentObject.
        :rtype: float
        """
        return self._score_min

    @score_min.setter
    def score_min(self, score_min: float) -> None:
        """
        Sets the score_min of this LearningShareableContentObject.
        The minimum score that could be achieved on the SCO. Maps to the SCORM 1.2 cmi.core.score.min property.

        :param score_min: The score_min of this LearningShareableContentObject.
        :type: float
        """
        

        self._score_min = score_min

    @property
    def suspend_data(self) -> str:
        """
        Gets the suspend_data of this LearningShareableContentObject.
        The unique information generated by the SCO from previous uses. Maps to the SCORM 1.2 cmi.suspend_data property.

        :return: The suspend_data of this LearningShareableContentObject.
        :rtype: str
        """
        return self._suspend_data

    @suspend_data.setter
    def suspend_data(self, suspend_data: str) -> None:
        """
        Sets the suspend_data of this LearningShareableContentObject.
        The unique information generated by the SCO from previous uses. Maps to the SCORM 1.2 cmi.suspend_data property.

        :param suspend_data: The suspend_data of this LearningShareableContentObject.
        :type: str
        """
        

        self._suspend_data = suspend_data

    @property
    def credit(self) -> str:
        """
        Gets the credit of this LearningShareableContentObject.
        Whether completing this course counts towards the overall assignment. Maps to the SCORM 1.2 cmi.core.credit property.

        :return: The credit of this LearningShareableContentObject.
        :rtype: str
        """
        return self._credit

    @credit.setter
    def credit(self, credit: str) -> None:
        """
        Sets the credit of this LearningShareableContentObject.
        Whether completing this course counts towards the overall assignment. Maps to the SCORM 1.2 cmi.core.credit property.

        :param credit: The credit of this LearningShareableContentObject.
        :type: str
        """
        if isinstance(credit, int):
            credit = str(credit)
        allowed_values = ["Credit", "NoCredit"]
        if credit.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for credit -> " + credit)
            self._credit = "outdated_sdk_version"
        else:
            self._credit = credit

    @property
    def entry(self) -> str:
        """
        Gets the entry of this LearningShareableContentObject.
        Whether the learner has previously accessed this SCO. Maps to the SCORM 1.2 cmi.core.entry property.

        :return: The entry of this LearningShareableContentObject.
        :rtype: str
        """
        return self._entry

    @entry.setter
    def entry(self, entry: str) -> None:
        """
        Sets the entry of this LearningShareableContentObject.
        Whether the learner has previously accessed this SCO. Maps to the SCORM 1.2 cmi.core.entry property.

        :param entry: The entry of this LearningShareableContentObject.
        :type: str
        """
        if isinstance(entry, int):
            entry = str(entry)
        allowed_values = ["AbInitio", "Resume", "Empty"]
        if entry.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for entry -> " + entry)
            self._entry = "outdated_sdk_version"
        else:
            self._entry = entry

    @property
    def mode(self) -> str:
        """
        Gets the mode of this LearningShareableContentObject.
        Identifies the mode in which the SCO should be presented to the learner. Maps to the SCORM 1.2 cmi.core.lesson_mode property.

        :return: The mode of this LearningShareableContentObject.
        :rtype: str
        """
        return self._mode

    @mode.setter
    def mode(self, mode: str) -> None:
        """
        Sets the mode of this LearningShareableContentObject.
        Identifies the mode in which the SCO should be presented to the learner. Maps to the SCORM 1.2 cmi.core.lesson_mode property.

        :param mode: The mode of this LearningShareableContentObject.
        :type: str
        """
        if isinstance(mode, int):
            mode = str(mode)
        allowed_values = ["Browse", "Normal", "Review"]
        if mode.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for mode -> " + mode)
            self._mode = "outdated_sdk_version"
        else:
            self._mode = mode

    @property
    def total_time(self) -> str:
        """
        Gets the total_time of this LearningShareableContentObject.
        The total amount of time the learner has spent in the SCO expressed as an ISO 8601 Duration, for example PT2H10M3.5S. Maps to the SCORM 1.2 cmi.core.total_time property.

        :return: The total_time of this LearningShareableContentObject.
        :rtype: str
        """
        return self._total_time

    @total_time.setter
    def total_time(self, total_time: str) -> None:
        """
        Sets the total_time of this LearningShareableContentObject.
        The total amount of time the learner has spent in the SCO expressed as an ISO 8601 Duration, for example PT2H10M3.5S. Maps to the SCORM 1.2 cmi.core.total_time property.

        :param total_time: The total_time of this LearningShareableContentObject.
        :type: str
        """
        

        self._total_time = total_time

    @property
    def session_time(self) -> str:
        """
        Gets the session_time of this LearningShareableContentObject.
        The amount of time spent in the SCO in this session expressed as an ISO-8601 Duration, for example PT2H10M3.5S. Maps to the SCORM 1.2 cmi.core.session_time property.

        :return: The session_time of this LearningShareableContentObject.
        :rtype: str
        """
        return self._session_time

    @session_time.setter
    def session_time(self, session_time: str) -> None:
        """
        Sets the session_time of this LearningShareableContentObject.
        The amount of time spent in the SCO in this session expressed as an ISO-8601 Duration, for example PT2H10M3.5S. Maps to the SCORM 1.2 cmi.core.session_time property.

        :param session_time: The session_time of this LearningShareableContentObject.
        :type: str
        """
        

        self._session_time = session_time

    @property
    def href(self) -> str:
        """
        Gets the href of this LearningShareableContentObject.
        The href from the course manifest for this SCO.

        :return: The href of this LearningShareableContentObject.
        :rtype: str
        """
        return self._href

    @href.setter
    def href(self, href: str) -> None:
        """
        Sets the href of this LearningShareableContentObject.
        The href from the course manifest for this SCO.

        :param href: The href of this LearningShareableContentObject.
        :type: str
        """
        

        self._href = href

    @property
    def parameters(self) -> str:
        """
        Gets the parameters of this LearningShareableContentObject.
        The parameters from the course manifest for this SCO.

        :return: The parameters of this LearningShareableContentObject.
        :rtype: str
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters: str) -> None:
        """
        Sets the parameters of this LearningShareableContentObject.
        The parameters from the course manifest for this SCO.

        :param parameters: The parameters of this LearningShareableContentObject.
        :type: str
        """
        

        self._parameters = parameters

    @property
    def launch_data(self) -> str:
        """
        Gets the launch_data of this LearningShareableContentObject.
        The launch data from the course manifest for this SCO.

        :return: The launch_data of this LearningShareableContentObject.
        :rtype: str
        """
        return self._launch_data

    @launch_data.setter
    def launch_data(self, launch_data: str) -> None:
        """
        Sets the launch_data of this LearningShareableContentObject.
        The launch data from the course manifest for this SCO.

        :param launch_data: The launch_data of this LearningShareableContentObject.
        :type: str
        """
        

        self._launch_data = launch_data

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

