# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class LimitDocs(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LimitDocs - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'key': 'str',
            'default_value': 'int',
            'description': 'str',
            'resource': 'str',
            'configurable': 'bool',
            'trackable': 'bool'
        }

        self.attribute_map = {
            'key': 'key',
            'default_value': 'defaultValue',
            'description': 'description',
            'resource': 'resource',
            'configurable': 'configurable',
            'trackable': 'trackable'
        }

        self._key = None
        self._default_value = None
        self._description = None
        self._resource = None
        self._configurable = None
        self._trackable = None

    @property
    def key(self) -> str:
        """
        Gets the key of this LimitDocs.


        :return: The key of this LimitDocs.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key: str) -> None:
        """
        Sets the key of this LimitDocs.


        :param key: The key of this LimitDocs.
        :type: str
        """
        

        self._key = key

    @property
    def default_value(self) -> int:
        """
        Gets the default_value of this LimitDocs.


        :return: The default_value of this LimitDocs.
        :rtype: int
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value: int) -> None:
        """
        Sets the default_value of this LimitDocs.


        :param default_value: The default_value of this LimitDocs.
        :type: int
        """
        

        self._default_value = default_value

    @property
    def description(self) -> str:
        """
        Gets the description of this LimitDocs.


        :return: The description of this LimitDocs.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this LimitDocs.


        :param description: The description of this LimitDocs.
        :type: str
        """
        

        self._description = description

    @property
    def resource(self) -> str:
        """
        Gets the resource of this LimitDocs.


        :return: The resource of this LimitDocs.
        :rtype: str
        """
        return self._resource

    @resource.setter
    def resource(self, resource: str) -> None:
        """
        Sets the resource of this LimitDocs.


        :param resource: The resource of this LimitDocs.
        :type: str
        """
        

        self._resource = resource

    @property
    def configurable(self) -> bool:
        """
        Gets the configurable of this LimitDocs.


        :return: The configurable of this LimitDocs.
        :rtype: bool
        """
        return self._configurable

    @configurable.setter
    def configurable(self, configurable: bool) -> None:
        """
        Sets the configurable of this LimitDocs.


        :param configurable: The configurable of this LimitDocs.
        :type: bool
        """
        

        self._configurable = configurable

    @property
    def trackable(self) -> bool:
        """
        Gets the trackable of this LimitDocs.


        :return: The trackable of this LimitDocs.
        :rtype: bool
        """
        return self._trackable

    @trackable.setter
    def trackable(self, trackable: bool) -> None:
        """
        Sets the trackable of this LimitDocs.


        :param trackable: The trackable of this LimitDocs.
        :type: bool
        """
        

        self._trackable = trackable

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

