# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class Literal(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Literal - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'string': 'str',
            'integer': 'int',
            'number': 'float',
            'date': 'date',
            'datetime': 'datetime',
            'special': 'str',
            'boolean': 'bool'
        }

        self.attribute_map = {
            'string': 'string',
            'integer': 'integer',
            'number': 'number',
            'date': 'date',
            'datetime': 'datetime',
            'special': 'special',
            'boolean': 'boolean'
        }

        self._string = None
        self._integer = None
        self._number = None
        self._date = None
        self._datetime = None
        self._special = None
        self._boolean = None

    @property
    def string(self) -> str:
        """
        Gets the string of this Literal.
        A string value

        :return: The string of this Literal.
        :rtype: str
        """
        return self._string

    @string.setter
    def string(self, string: str) -> None:
        """
        Sets the string of this Literal.
        A string value

        :param string: The string of this Literal.
        :type: str
        """
        

        self._string = string

    @property
    def integer(self) -> int:
        """
        Gets the integer of this Literal.
        A positive or negative whole number, including zero

        :return: The integer of this Literal.
        :rtype: int
        """
        return self._integer

    @integer.setter
    def integer(self, integer: int) -> None:
        """
        Sets the integer of this Literal.
        A positive or negative whole number, including zero

        :param integer: The integer of this Literal.
        :type: int
        """
        

        self._integer = integer

    @property
    def number(self) -> float:
        """
        Gets the number of this Literal.
        A positive or negative decimal number, including zero

        :return: The number of this Literal.
        :rtype: float
        """
        return self._number

    @number.setter
    def number(self, number: float) -> None:
        """
        Sets the number of this Literal.
        A positive or negative decimal number, including zero

        :param number: The number of this Literal.
        :type: float
        """
        

        self._number = number

    @property
    def date(self) -> date:
        """
        Gets the date of this Literal.
        A date value, must be in the format of yyyy-MM-dd, e.g. 2024-09-23. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date of this Literal.
        :rtype: date
        """
        return self._date

    @date.setter
    def date(self, date: date) -> None:
        """
        Sets the date of this Literal.
        A date value, must be in the format of yyyy-MM-dd, e.g. 2024-09-23. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date: The date of this Literal.
        :type: date
        """
        

        self._date = date

    @property
    def datetime(self) -> datetime:
        """
        Gets the datetime of this Literal.
        A date time value, must be in the format of yyyy-MM-dd'T'HH:mm:ss.SSSZ, e.g. 2024-10-02T01:01:01.111Z. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The datetime of this Literal.
        :rtype: datetime
        """
        return self._datetime

    @datetime.setter
    def datetime(self, datetime: datetime) -> None:
        """
        Sets the datetime of this Literal.
        A date time value, must be in the format of yyyy-MM-dd'T'HH:mm:ss.SSSZ, e.g. 2024-10-02T01:01:01.111Z. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param datetime: The datetime of this Literal.
        :type: datetime
        """
        

        self._datetime = datetime

    @property
    def special(self) -> str:
        """
        Gets the special of this Literal.
        A special value enum, such as Wildcard, Null, etc

        :return: The special of this Literal.
        :rtype: str
        """
        return self._special

    @special.setter
    def special(self, special: str) -> None:
        """
        Sets the special of this Literal.
        A special value enum, such as Wildcard, Null, etc

        :param special: The special of this Literal.
        :type: str
        """
        if isinstance(special, int):
            special = str(special)
        allowed_values = ["Wildcard", "Null", "Empty", "CurrentTime"]
        if special.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for special -> " + special)
            self._special = "outdated_sdk_version"
        else:
            self._special = special

    @property
    def boolean(self) -> bool:
        """
        Gets the boolean of this Literal.
        A boolean value

        :return: The boolean of this Literal.
        :rtype: bool
        """
        return self._boolean

    @boolean.setter
    def boolean(self, boolean: bool) -> None:
        """
        Sets the boolean of this Literal.
        A boolean value

        :param boolean: The boolean of this Literal.
        :type: bool
        """
        

        self._boolean = boolean

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

