# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import FlowHealthErrorInfo
    from . import LocaleFlowVersionInfo

class LocaleInfo(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LocaleInfo - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'status': 'str',
            'error_info': 'FlowHealthErrorInfo',
            'flow_version_info': 'LocaleFlowVersionInfo'
        }

        self.attribute_map = {
            'status': 'status',
            'error_info': 'errorInfo',
            'flow_version_info': 'flowVersionInfo'
        }

        self._status = None
        self._error_info = None
        self._flow_version_info = None

    @property
    def status(self) -> str:
        """
        Gets the status of this LocaleInfo.
        Status of health computation for this flow version.

        :return: The status of this LocaleInfo.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this LocaleInfo.
        Status of health computation for this flow version.

        :param status: The status of this LocaleInfo.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["InProgress", "Completed", "Error"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def error_info(self) -> 'FlowHealthErrorInfo':
        """
        Gets the error_info of this LocaleInfo.
        Error details for the flow version, if any.

        :return: The error_info of this LocaleInfo.
        :rtype: FlowHealthErrorInfo
        """
        return self._error_info

    @error_info.setter
    def error_info(self, error_info: 'FlowHealthErrorInfo') -> None:
        """
        Sets the error_info of this LocaleInfo.
        Error details for the flow version, if any.

        :param error_info: The error_info of this LocaleInfo.
        :type: FlowHealthErrorInfo
        """
        

        self._error_info = error_info

    @property
    def flow_version_info(self) -> 'LocaleFlowVersionInfo':
        """
        Gets the flow_version_info of this LocaleInfo.
        Info about given flow version.

        :return: The flow_version_info of this LocaleInfo.
        :rtype: LocaleFlowVersionInfo
        """
        return self._flow_version_info

    @flow_version_info.setter
    def flow_version_info(self, flow_version_info: 'LocaleFlowVersionInfo') -> None:
        """
        Sets the flow_version_info of this LocaleInfo.
        Info about given flow version.

        :param flow_version_info: The flow_version_info of this LocaleInfo.
        :type: LocaleFlowVersionInfo
        """
        

        self._flow_version_info = flow_version_info

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

